/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.activeio.command.WireFormat;
import org.activemq.transport.MutexTransport;
import org.activemq.transport.ResponseCorrelator;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportLogger;
import org.activemq.transport.TransportServer;
import org.activemq.transport.WireFormatNegotiator;
import org.activemq.transport.tcp.TcpTransport;
import org.activemq.transport.tcp.TcpTransportServer;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class TcpTransportFactory
extends TransportFactory {
    public Transport doConnect(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            WireFormat wf = this.createWireFormat(options);
            TcpTransport tcpTransport = new TcpTransport(wf, location);
            Transport rc = TcpTransportFactory.configure(tcpTransport, wf, options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doConnect(URI location, Executor ex) throws IOException {
        return this.doConnect(location);
    }

    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            WireFormat wf = this.createWireFormat(options);
            TcpTransport tcpTransport = new TcpTransport(wf, location);
            Transport rc = TcpTransportFactory.compositeConfigure(tcpTransport, wf, options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid connect parameters: " + options);
            }
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport doCompositeConnect(URI location, Executor ex) throws IOException {
        return this.doCompositeConnect(location);
    }

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParamters(location));
            TcpTransportServer server = new TcpTransportServer(location);
            server.setWireFormatFactory(this.createWireFormatFactory(options));
            IntrospectionSupport.setProperties(server, options);
            if (!options.isEmpty()) {
                throw new IllegalArgumentException("Invalid bind parameters: " + options);
            }
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public static Transport configure(TcpTransport tcpTransport, WireFormat format, Map options) {
        IntrospectionSupport.setProperties(tcpTransport, options);
        Transport transport = tcpTransport;
        if (tcpTransport.isTrace()) {
            transport = new TransportLogger(transport);
        }
        transport = new WireFormatNegotiator(transport, format, tcpTransport.getMinmumWireFormatVersion());
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public static Transport compositeConfigure(TcpTransport tcpTransport, WireFormat format, Map options) {
        IntrospectionSupport.setProperties(tcpTransport, options);
        Transport transport = tcpTransport;
        if (tcpTransport.isTrace()) {
            transport = new TransportLogger(transport);
        }
        transport = new WireFormatNegotiator(transport, format, tcpTransport.getMinmumWireFormatVersion());
        return transport;
    }
}

