/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import org.activeio.command.WireFormat;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;
import org.activemq.transport.tcp.TcpBufferedOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransport
implements Transport,
Runnable {
    private static final Log log = LogFactory.getLog((Class)TcpTransport.class);
    protected int soTimeout = 10000;
    protected int socketBufferSize = 65536;
    protected Socket socket;
    protected DataOutputStream dataOut;
    protected DataInputStream dataIn;
    private Thread runner;
    private WireFormat wireFormat;
    private AtomicBoolean closed;
    private AtomicBoolean started;
    private TransportListener transportListener;
    private boolean daemon = false;
    private boolean trace;
    private int minmumWireFormatVersion;

    protected TcpTransport(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
        this.closed = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
    }

    public TcpTransport(WireFormat wireFormat, URI remoteLocation) throws UnknownHostException, IOException {
        this(wireFormat);
        this.socket = this.createSocket(remoteLocation);
        this.initializeStreams();
    }

    public TcpTransport(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        this(wireFormat);
        this.socket = this.createSocket(remoteLocation, localLocation);
        this.initializeStreams();
    }

    public TcpTransport(WireFormat wireFormat, Socket socket) throws IOException {
        this(wireFormat);
        this.socket = socket;
        this.initialiseSocket(socket);
        this.initializeStreams();
        this.daemon = true;
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.runner = new Thread((Runnable)this, this.toString());
            this.runner.setDaemon(this.daemon);
            this.runner.start();
        }
    }

    public void stop() {
        if (this.closed.compareAndSet(false, true)) {
            this.started.set(false);
            try {
                this.closeStreams();
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Caught while closing: " + e + ". Now Closed"), (Throwable)e);
            }
        }
        this.closed.set(true);
    }

    public void oneway(Command command) throws IOException {
        this.wireFormat.marshal((Object)command, this.dataOut);
        this.dataOut.flush();
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    public Object narrow(Class target) {
        boolean assignableFrom = target.isAssignableFrom(this.getClass());
        if (assignableFrom) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "TcpTransport: " + this.socket;
    }

    public void run() {
        log.trace((Object)"TCP consumer thread starting");
        while (!this.closed.get()) {
            try {
                Command command = (Command)this.wireFormat.unmarshal(this.dataIn);
                if (command == null || this.transportListener == null) continue;
                this.transportListener.onCommand(command);
            }
            catch (SocketTimeoutException e) {
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                this.stop();
                if (this.transportListener == null) continue;
                this.transportListener.onException(e);
            }
        }
    }

    protected Socket createSocket(URI remoteLocation) throws UnknownHostException, IOException {
        InetSocketAddress sockAddress = new InetSocketAddress(remoteLocation.getHost(), remoteLocation.getPort());
        Socket sock = new Socket();
        this.initialiseSocket(sock);
        sock.connect(sockAddress);
        return sock;
    }

    protected Socket createSocket(URI remoteLocation, URI localLocation) throws IOException, UnknownHostException {
        InetSocketAddress sockAddress = new InetSocketAddress(remoteLocation.getHost(), remoteLocation.getPort());
        InetSocketAddress localAddress = new InetSocketAddress(InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
        Socket sock = new Socket();
        this.initialiseSocket(sock);
        sock.bind(localAddress);
        sock.connect(sockAddress);
        return sock;
    }

    protected void initialiseSocket(Socket sock) throws SocketException {
        try {
            sock.setReceiveBufferSize(this.socketBufferSize);
            sock.setSendBufferSize(this.socketBufferSize);
        }
        catch (SocketException se) {
            log.debug((Object)("Cannot set socket buffer size = " + this.socketBufferSize), (Throwable)se);
        }
        sock.setSoTimeout(this.soTimeout);
    }

    protected void initializeStreams() throws IOException {
        BufferedInputStream buffIn = new BufferedInputStream(this.socket.getInputStream(), 8192);
        this.dataIn = new DataInputStream(buffIn);
        TcpBufferedOutputStream buffOut = new TcpBufferedOutputStream(this.socket.getOutputStream(), 8192);
        this.dataOut = new DataOutputStream(buffOut);
    }

    protected void closeStreams() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
        }
        if (this.dataIn != null) {
            this.dataIn.close();
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public int getMinmumWireFormatVersion() {
        return this.minmumWireFormatVersion;
    }

    public void setMinmumWireFormatVersion(int minmumWireFormatVersion) {
        this.minmumWireFormatVersion = minmumWireFormatVersion;
    }
}

