/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.failover;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.activemq.transport.MutexTransport;
import org.activemq.transport.ResponseCorrelator;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.activemq.transport.failover.FailoverTransport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class FailoverTransportFactory
extends TransportFactory {
    public Transport doConnect(URI location) throws IOException {
        try {
            Transport transport = this.createTransport(URISupport.parseComposite(location));
            transport = new MutexTransport(transport);
            transport = new ResponseCorrelator(transport);
            return transport;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            return this.createTransport(URISupport.parseComposite(location));
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport createTransport(URISupport.CompositeData compositData) throws IOException {
        FailoverTransport transport = this.createTransport(compositData.getParameters());
        URI[] components = compositData.getComponents();
        transport.getURIs().addAll(Arrays.asList(components));
        try {
            transport.reconnect();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        return transport;
    }

    public FailoverTransport createTransport(Map parameters) throws IOException {
        FailoverTransport transport = new FailoverTransport();
        IntrospectionSupport.setProperties(transport, parameters);
        return transport;
    }

    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("Invalid server URI: " + location);
    }
}

