/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.discovery;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.activemq.transport.discovery.DiscoveryAgent;
import org.activemq.transport.discovery.DiscoveryAgentFactory;
import org.activemq.transport.discovery.DiscoveryTransport;
import org.activemq.transport.discovery.DiscoveryTransportServer;
import org.activemq.transport.failover.FailoverTransportFactory;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class DiscoveryTransportFactory
extends FailoverTransportFactory {
    public Transport createTransport(URISupport.CompositeData compositData) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>(compositData.getParameters());
        DiscoveryTransport transport = new DiscoveryTransport(super.createTransport(parameters));
        DiscoveryAgent discoveryAgent = DiscoveryAgentFactory.createDiscoveryAgent(transport.getDiscovery());
        if (compositData.getHost() != null) {
            parameters.put("discovery.group", compositData.getHost());
        }
        IntrospectionSupport.setProperties(discoveryAgent, parameters, "discovery.");
        transport.setDiscoveryAgent(discoveryAgent);
        return transport;
    }

    public TransportServer doBind(URI location) throws IOException {
        try {
            URISupport.CompositeData compositData = URISupport.parseComposite(location);
            URI[] components = compositData.getComponents();
            if (components.length != 1) {
                throw new IOException("Invalid location: " + location + ", the location must have 1 and only 1 composite URI in it.");
            }
            HashMap<String, String> parameters = new HashMap<String, String>(compositData.getParameters());
            DiscoveryTransportServer server = new DiscoveryTransportServer(TransportFactory.bind(components[0]));
            IntrospectionSupport.setProperties(server, parameters);
            DiscoveryAgent discoveryAgent = DiscoveryAgentFactory.createDiscoveryAgent(server.getDiscovery());
            if (compositData.getHost() != null) {
                parameters.put("discovery.group", compositData.getHost());
            }
            IntrospectionSupport.setProperties(discoveryAgent, parameters, "discovery.");
            server.setDiscoveryAgent(discoveryAgent);
            if (!parameters.isEmpty()) {
                throw new IllegalArgumentException("Invalid transport parameters: " + parameters);
            }
            return server;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }
}

