/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.io.IOException;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;

public class TransportFilter
implements Transport,
TransportListener {
    protected final Transport next;
    protected TransportListener commandListener;

    public TransportFilter(Transport next) {
        this.next = next;
    }

    public void setTransportListener(TransportListener channelListener) {
        this.commandListener = channelListener;
        if (channelListener == null) {
            this.next.setTransportListener(null);
        } else {
            this.next.setTransportListener(this);
        }
    }

    public void start() throws Exception {
        if (this.next == null) {
            throw new IOException("The next channel has not been set.");
        }
        if (this.commandListener == null) {
            throw new IOException("The command listener has not been set.");
        }
        this.next.start();
    }

    public void stop() throws Exception {
        this.next.stop();
    }

    public void onCommand(Command command) {
        this.commandListener.onCommand(command);
    }

    public Transport getNext() {
        return this.next;
    }

    public TransportListener getCommandListener() {
        return this.commandListener;
    }

    public String toString() {
        return this.next.toString();
    }

    public void oneway(Command command) throws IOException {
        this.next.oneway(command);
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        return this.next.asyncRequest(command);
    }

    public Response request(Command command) throws IOException {
        return this.next.request(command);
    }

    public void onException(IOException error) {
        this.commandListener.onException(error);
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.next.narrow(target);
    }
}

