/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.activeio.FactoryFinder;
import org.activeio.command.WireFormat;
import org.activeio.command.WireFormatFactory;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportServer;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.IntrospectionSupport;

public abstract class TransportFactory {
    private static final FactoryFinder transportFactoryFinder = new FactoryFinder("META-INF/services/org/activemq/transport/");
    private static final FactoryFinder wireFormatFactoryFinder = new FactoryFinder("META-INF/services/org/activemq/wireformat/");
    private static final ConcurrentHashMap transportFactorys = new ConcurrentHashMap();

    public abstract Transport doConnect(URI var1) throws Exception;

    public abstract Transport doCompositeConnect(URI var1) throws Exception;

    public abstract TransportServer doBind(URI var1) throws IOException;

    public Transport doConnect(URI location, Executor ex) throws Exception {
        return this.doConnect(location);
    }

    public Transport doCompositeConnect(URI location, Executor ex) throws Exception {
        return this.doCompositeConnect(location);
    }

    public static Transport connect(URI location) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doConnect(location);
    }

    public static Transport connect(URI location, Executor ex) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doConnect(location, ex);
    }

    public static Transport compositeConnect(URI location) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doCompositeConnect(location);
    }

    public static Transport compositeConnect(URI location, Executor ex) throws Exception {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doCompositeConnect(location, ex);
    }

    public static TransportServer bind(URI location) throws IOException {
        TransportFactory tf = TransportFactory.findTransportFactory(location);
        return tf.doBind(location);
    }

    private static TransportFactory findTransportFactory(URI location) throws IOException {
        String scheme = location.getScheme();
        TransportFactory tf = (TransportFactory)transportFactorys.get((Object)scheme);
        if (tf == null) {
            try {
                tf = (TransportFactory)transportFactoryFinder.newInstance(scheme);
                transportFactorys.put((Object)scheme, (Object)tf);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Transport scheme NOT recognized: [" + scheme + "]", e);
            }
        }
        return tf;
    }

    protected WireFormat createWireFormat(Map options) throws IOException {
        WireFormatFactory factory = this.createWireFormatFactory(options);
        WireFormat format = factory.createWireFormat();
        return format;
    }

    protected WireFormatFactory createWireFormatFactory(Map options) throws IOException {
        String wireFormat = (String)options.get("wireFormat");
        if (wireFormat == null) {
            wireFormat = "default";
        }
        try {
            WireFormatFactory wff = (WireFormatFactory)wireFormatFactoryFinder.newInstance(wireFormat);
            IntrospectionSupport.setProperties(wff, options, "wireFormat.");
            return wff;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create wire format factory for: " + wireFormat + ", reason: " + e, e);
        }
    }
}

