/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.thread;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;

public class TaskRunnerFactory {
    private final int maxIterationsPerRun;
    private final Executor executor;

    public TaskRunnerFactory() {
        this(TaskRunnerFactory.createDefaultExecutor("ActiveMQ Task", 5, true), 1000);
    }

    private static Executor createDefaultExecutor(final String name, final int priority, final boolean daemon) {
        ScheduledThreadPoolExecutor rc = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, name);
                thread.setDaemon(daemon);
                thread.setPriority(priority);
                return thread;
            }
        });
        return rc;
    }

    public TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun) {
        this(TaskRunnerFactory.createDefaultExecutor(name, priority, daemon), maxIterationsPerRun);
    }

    public TaskRunnerFactory(Executor executor, int maxIterationsPerRun) {
        this.executor = executor;
        this.maxIterationsPerRun = maxIterationsPerRun;
    }

    public TaskRunner createTaskRunner(Task task) {
        return new SimpleTaskRunner(task);
    }

    private class SimpleTaskRunner
    implements TaskRunner {
        private final Task task;
        private final Runnable runable;
        private boolean queued;
        private boolean shutdown;
        private boolean iterating;

        public SimpleTaskRunner(Task task) {
            this.task = task;
            this.runable = new Runnable(){

                public void run() {
                    SimpleTaskRunner.this.runTask();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() throws InterruptedException {
            Runnable runnable = this.runable;
            synchronized (runnable) {
                if (this.queued || this.shutdown) {
                    return;
                }
                this.queued = true;
                if (!this.iterating) {
                    TaskRunnerFactory.this.executor.execute(this.runable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask() {
            Runnable runnable = this.runable;
            synchronized (runnable) {
                this.queued = false;
                if (this.shutdown) {
                    this.runable.notifyAll();
                    return;
                }
                this.iterating = true;
            }
            boolean done = false;
            for (int i = 0; i < TaskRunnerFactory.this.maxIterationsPerRun; ++i) {
                if (this.task.iterate()) continue;
                done = true;
                break;
            }
            Runnable runnable2 = this.runable;
            synchronized (runnable2) {
                this.iterating = false;
                if (this.shutdown) {
                    this.queued = false;
                    this.runable.notifyAll();
                    return;
                }
                if (!done) {
                    this.queued = true;
                }
                if (this.queued) {
                    TaskRunnerFactory.this.executor.execute(this.runable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws InterruptedException {
            Runnable runnable = this.runable;
            synchronized (runnable) {
                this.shutdown = true;
                while (this.iterating) {
                    this.runable.wait();
                }
            }
        }
    }
}

