/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.activeio.journal.RecordLocation;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.JournalQueueAck;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageId;
import org.activemq.memory.UsageManager;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.MessageStore;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.store.journal.JournalTransactionStore;
import org.activemq.transaction.Synchronization;
import org.activemq.util.Callback;
import org.activemq.util.TransactionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)JournalMessageStore.class);
    protected final JournalPersistenceAdapter peristenceAdapter;
    protected final JournalTransactionStore transactionStore;
    protected final MessageStore longTermStore;
    protected final ActiveMQDestination destination;
    protected final TransactionTemplate transactionTemplate;
    private LinkedHashMap messages = new LinkedHashMap();
    private ArrayList messageAcks = new ArrayList();
    private LinkedHashMap cpAddedMessageIds;
    protected RecordLocation lastLocation;
    protected HashSet inFlightTxLocations = new HashSet();
    protected UsageManager usageManager;

    public JournalMessageStore(JournalPersistenceAdapter adapter, MessageStore checkpointStore, ActiveMQDestination destination) {
        this.peristenceAdapter = adapter;
        this.transactionStore = adapter.getTransactionStore();
        this.longTermStore = checkpointStore;
        this.destination = destination;
        this.transactionTemplate = new TransactionTemplate(adapter, new ConnectionContext());
        this.usageManager = this.peristenceAdapter.getUsageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(ConnectionContext context, final Message message) throws IOException {
        final MessageId id = message.getMessageId();
        final boolean debug = log.isDebugEnabled();
        message.incrementReferenceCount();
        final RecordLocation location = this.peristenceAdapter.writeCommand(message, message.isResponseRequired());
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled message add for: " + id + ", at: " + location));
            }
            this.addMessage(message, location);
        } else {
            if (debug) {
                log.debug((Object)("Journalled transacted message add for: " + id + ", at: " + location));
            }
            JournalMessageStore journalMessageStore = this;
            synchronized (journalMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.addMessage(this, message, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() {
                    if (debug) {
                        log.debug((Object)("Transacted message add commit for: " + id + ", at: " + location));
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                        JournalMessageStore.this.addMessage(message, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() {
                    if (debug) {
                        log.debug((Object)("Transacted message add rollback for: " + id + ", at: " + location));
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                    }
                    message.decrementReferenceCount();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(Message message, RecordLocation location) {
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.lastLocation = location;
            MessageId id = message.getMessageId();
            this.messages.put(id, message);
        }
    }

    public void replayAddMessage(ConnectionContext context, Message message) {
        try {
            Message t = this.longTermStore.getMessage(message.getMessageId());
            if (t == null) {
                this.longTermStore.addMessage(context, message);
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Could not replay add for message '" + message.getMessageId() + "'.  Message may have already been added. reason: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(ConnectionContext context, final MessageAck ack) throws IOException {
        final boolean debug = log.isDebugEnabled();
        JournalQueueAck remove = new JournalQueueAck();
        remove.setDestination(this.destination);
        remove.setMessageAck(ack);
        final RecordLocation location = this.peristenceAdapter.writeCommand(remove, ack.isResponseRequired());
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled message remove for: " + ack.getLastMessageId() + ", at: " + location));
            }
            this.removeMessage(ack, location);
        } else {
            if (debug) {
                log.debug((Object)("Journalled transacted message remove for: " + ack.getLastMessageId() + ", at: " + location));
            }
            JournalMessageStore journalMessageStore = this;
            synchronized (journalMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.removeMessage(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() {
                    if (debug) {
                        log.debug((Object)("Transacted message remove commit for: " + ack.getLastMessageId() + ", at: " + location));
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                        JournalMessageStore.this.removeMessage(ack, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() {
                    if (debug) {
                        log.debug((Object)("Transacted message remove rollback for: " + ack.getLastMessageId() + ", at: " + location));
                    }
                    JournalMessageStore journalMessageStore = JournalMessageStore.this;
                    synchronized (journalMessageStore) {
                        JournalMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessage(MessageAck ack, RecordLocation location) {
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.lastLocation = location;
            MessageId id = ack.getLastMessageId();
            Message message = (Message)this.messages.remove(id);
            if (message == null) {
                this.messageAcks.add(ack);
            } else {
                message.decrementReferenceCount();
            }
        }
    }

    public void replayRemoveMessage(ConnectionContext context, MessageAck messageAck) {
        try {
            Message t = this.longTermStore.getMessage(messageAck.getLastMessageId());
            if (t != null) {
                this.longTermStore.removeMessage(context, messageAck);
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Could not replay acknowledge for message '" + messageAck.getLastMessageId() + "'.  Message may have already been acknowledged. reason: " + e));
        }
    }

    public RecordLocation checkpoint() throws IOException {
        return this.checkpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint(final Callback postCheckpointTest) throws IOException {
        ArrayList cpActiveJournalLocations;
        ArrayList cpRemovedMessageLocations;
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.cpAddedMessageIds = this.messages;
            cpRemovedMessageLocations = this.messageAcks;
            cpActiveJournalLocations = new ArrayList(this.inFlightTxLocations);
            this.messages = new LinkedHashMap();
            this.messageAcks = new ArrayList();
        }
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                Iterator<Object> iterator = JournalMessageStore.this.cpAddedMessageIds.values().iterator();
                while (iterator.hasNext()) {
                    Message message = (Message)iterator.next();
                    try {
                        JournalMessageStore.this.longTermStore.addMessage(JournalMessageStore.this.transactionTemplate.getContext(), message);
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Message could not be added to long term store: " + e.getMessage()), e);
                    }
                    iterator.remove();
                    message.decrementReferenceCount();
                }
                iterator = cpRemovedMessageLocations.iterator();
                while (iterator.hasNext()) {
                    try {
                        MessageAck ack = (MessageAck)iterator.next();
                        JournalMessageStore.this.longTermStore.removeMessage(JournalMessageStore.this.transactionTemplate.getContext(), ack);
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Message could not be removed from long term store: " + e.getMessage()), e);
                    }
                }
                if (postCheckpointTest != null) {
                    postCheckpointTest.execute();
                }
            }
        });
        journalMessageStore = this;
        synchronized (journalMessageStore) {
            this.cpAddedMessageIds = null;
        }
        if (cpActiveJournalLocations.size() > 0) {
            Collections.sort(cpActiveJournalLocations);
            return (RecordLocation)cpActiveJournalLocations.get(0);
        }
        return this.lastLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(MessageId identity) throws IOException {
        Message answer = null;
        JournalMessageStore journalMessageStore = this;
        synchronized (journalMessageStore) {
            answer = (Message)this.messages.get(identity);
            if (answer == null && this.cpAddedMessageIds != null) {
                answer = (Message)this.cpAddedMessageIds.get(identity);
            }
        }
        if (answer != null) {
            return answer;
        }
        return this.longTermStore.getMessage(identity);
    }

    public void recover(MessageRecoveryListener listener) throws Throwable {
        this.peristenceAdapter.checkpoint(true);
        this.longTermStore.recover(listener);
    }

    public void start() throws IOException {
        this.longTermStore.start();
    }

    public void stop(long timeout) throws IOException {
        this.longTermStore.stop(timeout);
    }

    public MessageStore getLongTermMessageStore() {
        return this.longTermStore;
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.peristenceAdapter.checkpoint(true);
        this.longTermStore.removeAllMessages(context);
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }
}

