/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.activeio.Packet;
import org.activeio.command.WireFormat;
import org.activeio.packet.ByteArrayPacket;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.Message;
import org.activemq.command.MessageId;
import org.activemq.command.SubscriptionInfo;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.activemq.store.jdbc.JDBCMessageStore;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.activemq.store.jdbc.TransactionContext;
import org.activemq.util.IOExceptionSupport;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQTopic topic) {
        super(persistenceAdapter, adapter, wireFormat, topic);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        long seq = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doSetLastAck(c, this.destination, clientId, subscriptionName, seq);
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create("Failed to store acknowledgment for: " + clientId + " on message " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Throwable {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doRecoverSubscription(c, this.destination, clientId, subscriptionName, new JDBCMessageRecoveryListener(){

                public void recoverMessage(long sequenceId, byte[] data) throws Throwable {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal((Packet)new ByteArrayPacket(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    listener.recoverMessage(msg);
                }
            });
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create("Failed to recover subscription: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doSetSubscriberEntry(c, this.destination, clientId, subscriptionName, selector, retroactive);
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create("Failed to lookup subscription for info: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo subscriptionInfo = this.adapter.doGetSubscriberEntry(c, this.destination, clientId, subscriptionName);
            return subscriptionInfo;
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create("Failed to lookup subscription for: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doDeleteSubscription(c, this.destination, clientId, subscriptionName);
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create("Failed to remove subscription for: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }
}

