/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.security;

import java.util.Set;
import javax.jms.JMSException;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerFilter;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.Destination;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQTempDestination;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.ProducerInfo;
import org.activemq.filter.BooleanExpression;
import org.activemq.filter.DestinationMap;
import org.activemq.filter.MessageEvaluationContext;
import org.activemq.security.SecurityContext;

public class SimpleAuthorizationBroker
extends BrokerFilter {
    private final DestinationMap writeACLs;
    private final DestinationMap readACLs;
    private final DestinationMap adminACLs;
    private boolean filterReads = true;

    public SimpleAuthorizationBroker(Broker next, DestinationMap writeACLs, DestinationMap readACLs, DestinationMap adminACLs) {
        super(next);
        this.writeACLs = writeACLs;
        this.readACLs = readACLs;
        this.adminACLs = adminACLs;
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Throwable {
        Set allowedACLs;
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!(destination.isTemporary() && ((ActiveMQTempDestination)destination).getConnectionId().equals(context.getConnectionId().getConnectionId()) || (allowedACLs = this.adminACLs.get(destination)) == null || securityContext.isInOneOf(allowedACLs))) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to create: " + destination);
        }
        return super.addDestination(context, destination);
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Throwable {
        Set allowedACLs;
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!(destination.isTemporary() && ((ActiveMQTempDestination)destination).getConnectionId().equals(context.getConnectionId().getConnectionId()) || (allowedACLs = this.adminACLs.get(destination)) == null || securityContext.isInOneOf(allowedACLs))) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to remove: " + destination);
        }
        super.removeDestination(context, destination, timeout);
    }

    public void addConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        final SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        Set allowedACLs = this.readACLs.get(info.getDestination());
        if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + subject.getUserName() + " is not authorized to read from: " + info.getDestination());
        }
        subject.getAuthorizedReadDests().put((Object)info.getDestination(), (Object)info.getDestination());
        if (this.filterReads) {
            info.setAdditionalPredicate(new BooleanExpression(){

                public boolean matches(MessageEvaluationContext message) throws JMSException {
                    if (!subject.getAuthorizedReadDests().contains((Object)message.getDestination())) {
                        Set allowedACLs = SimpleAuthorizationBroker.this.readACLs.get(message.getDestination());
                        if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                            return false;
                        }
                        subject.getAuthorizedReadDests().put((Object)message.getDestination(), (Object)message.getDestination());
                    }
                    return true;
                }

                public Object evaluate(MessageEvaluationContext message) throws JMSException {
                    return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        super.addConsumer(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
        SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (info.getDestination() != null) {
            Set allowedACLs = this.writeACLs.get(info.getDestination());
            if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + subject.getUserName() + " is not authorized to write to: " + info.getDestination());
            }
            subject.getAuthorizedWriteDests().put((Object)info.getDestination(), (Object)info.getDestination());
        }
        super.addProducer(context, info);
    }

    public void send(ConnectionContext context, Message messageSend) throws Throwable {
        SecurityContext subject = context.getSecurityContext();
        if (subject == null) {
            throw new SecurityException("User is not authenticated.");
        }
        if (!subject.getAuthorizedWriteDests().contains((Object)messageSend.getDestination())) {
            Set allowedACLs = this.writeACLs.get(messageSend.getDestination());
            if (allowedACLs != null && !subject.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + subject.getUserName() + " is not authorized to write to: " + messageSend.getDestination());
            }
            subject.getAuthorizedWriteDests().put((Object)messageSend.getDestination(), (Object)messageSend.getDestination());
        }
        super.send(context, messageSend);
    }

    public boolean isFilterReads() {
        return this.filterReads;
    }

    public void setFilterReads(boolean filterReads) {
        this.filterReads = filterReads;
    }
}

