/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.security;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class SecurityContext {
    final String userName;
    final ConcurrentHashMap authorizedReadDests = new ConcurrentHashMap();
    final ConcurrentHashMap authorizedWriteDests = new ConcurrentHashMap();

    public SecurityContext(String userName) {
        this.userName = userName;
    }

    public boolean isInOneOf(Set allowedPrincipals) {
        HashSet set = new HashSet(this.getPrincipals());
        set.retainAll(allowedPrincipals);
        return set.size() > 0;
    }

    public abstract Set getPrincipals();

    public String getUserName() {
        return this.userName;
    }

    public ConcurrentHashMap getAuthorizedReadDests() {
        return this.authorizedReadDests;
    }

    public ConcurrentHashMap getAuthorizedWriteDests() {
        return this.authorizedWriteDests;
    }
}

