/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.JournalTransaction;
import org.activemq.command.TransactionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class JournalTransactionMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 54;
    }

    public DataStructure createObject() {
        return new JournalTransaction();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        JournalTransaction info = (JournalTransaction)o;
        info.setTransactionId((TransactionId)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setType(dataIn.readByte());
        info.setWasPrepared(bs.readBoolean());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        JournalTransaction info = (JournalTransaction)o;
        int rc = super.marshal1(wireFormat, o, bs);
        bs.writeBoolean(info.getWasPrepared());
        return (rc += this.marshal1NestedObject(wireFormat, info.getTransactionId(), bs)) + 1;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        JournalTransaction info = (JournalTransaction)o;
        this.marshal2NestedObject(wireFormat, info.getTransactionId(), dataOut, bs);
        dataOut.writeByte(info.getType());
        bs.readBoolean();
    }
}

