/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.activeio.command.ClassLoading;
import org.activemq.command.DataStructure;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;

public abstract class DataStreamMarshaller {
    public static final Constructor STACK_TRACE_ELEMENT_CONSTRUCTOR;

    public abstract byte getDataStructureType();

    public abstract DataStructure createObject();

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        return 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
    }

    protected DataStructure unmarsalNestedObject(OpenWireFormat wireFormat, DataInputStream dataIn, BooleanStream bs) throws IOException {
        return wireFormat.unmarshalNestedObject(dataIn, bs);
    }

    protected int marshal1NestedObject(OpenWireFormat wireFormat, DataStructure o, BooleanStream bs) throws IOException {
        return wireFormat.marshal1NestedObject(o, bs);
    }

    protected void marshal2NestedObject(OpenWireFormat wireFormat, DataStructure o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        wireFormat.marshal2NestedObject(o, dataOut, bs);
    }

    protected DataStructure unmarsalCachedObject(OpenWireFormat wireFormat, DataInputStream dataIn, BooleanStream bs) throws IOException {
        if (wireFormat.isCacheEnabled()) {
            if (bs.readBoolean()) {
                short index = dataIn.readShort();
                DataStructure object = wireFormat.unmarshalNestedObject(dataIn, bs);
                wireFormat.setInUnmarshallCache(index, object);
                return object;
            }
            short index = dataIn.readShort();
            return wireFormat.getFromUnmarshallCache(index);
        }
        return wireFormat.unmarshalNestedObject(dataIn, bs);
    }

    protected int marshal1CachedObject(OpenWireFormat wireFormat, DataStructure o, BooleanStream bs) throws IOException {
        if (wireFormat.isCacheEnabled()) {
            Short index = wireFormat.getMarshallCacheIndex(o);
            bs.writeBoolean(index == null);
            if (index == null) {
                int rc = wireFormat.marshal1NestedObject(o, bs);
                wireFormat.addToMarshallCache(o);
                return 2 + rc;
            }
            return 2;
        }
        return wireFormat.marshal1NestedObject(o, bs);
    }

    protected void marshal2CachedObject(OpenWireFormat wireFormat, DataStructure o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        if (wireFormat.isCacheEnabled()) {
            Short index = wireFormat.getMarshallCacheIndex(o);
            if (bs.readBoolean()) {
                dataOut.writeShort(index.shortValue());
                wireFormat.marshal2NestedObject(o, dataOut, bs);
            } else {
                dataOut.writeShort(index.shortValue());
            }
        } else {
            wireFormat.marshal2NestedObject(o, dataOut, bs);
        }
    }

    protected Throwable unmarsalThrowable(OpenWireFormat wireFormat, DataInputStream dataIn, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            String clazz = this.readString(dataIn, bs);
            String message = this.readString(dataIn, bs);
            Throwable o = this.createThrowable(clazz, message);
            if (wireFormat.isStackTraceEnabled()) {
                if (STACK_TRACE_ELEMENT_CONSTRUCTOR != null) {
                    StackTraceElement[] ss = new StackTraceElement[dataIn.readShort()];
                    for (int i = 0; i < ss.length; ++i) {
                        try {
                            ss[i] = (StackTraceElement)STACK_TRACE_ELEMENT_CONSTRUCTOR.newInstance(this.readString(dataIn, bs), this.readString(dataIn, bs), this.readString(dataIn, bs), new Integer(dataIn.readInt()));
                            continue;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    o.setStackTrace(ss);
                } else {
                    int size = dataIn.readInt();
                    for (int i = 0; i < size; ++i) {
                        this.readString(dataIn, bs);
                        this.readString(dataIn, bs);
                        this.readString(dataIn, bs);
                        dataIn.readInt();
                    }
                }
                o.initCause(this.unmarsalThrowable(wireFormat, dataIn, bs));
            }
            return o;
        }
        return null;
    }

    private Throwable createThrowable(String className, String message) {
        try {
            Class clazz = ClassLoading.loadClass((String)className, (ClassLoader)DataStreamMarshaller.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(String.class);
            return (Throwable)constructor.newInstance(message);
        }
        catch (Throwable e) {
            return new Throwable(className + ": " + message);
        }
    }

    protected int marshalThrowable(OpenWireFormat wireFormat, Throwable o, BooleanStream bs) throws IOException {
        if (o == null) {
            bs.writeBoolean(false);
            return 0;
        }
        int rc = 0;
        bs.writeBoolean(true);
        rc += this.writeString(o.getClass().getName(), bs);
        rc += this.writeString(o.getMessage(), bs);
        if (wireFormat.isStackTraceEnabled()) {
            rc += 2;
            StackTraceElement[] stackTrace = o.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement element = stackTrace[i];
                rc += this.writeString(element.getClassName(), bs);
                rc += this.writeString(element.getMethodName(), bs);
                rc += this.writeString(element.getFileName(), bs);
                rc += 4;
            }
            rc += this.marshalThrowable(wireFormat, o.getCause(), bs);
        }
        return rc;
    }

    protected void marshalThrowable(OpenWireFormat wireFormat, Throwable o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            this.writeString(o.getClass().getName(), dataOut, bs);
            this.writeString(o.getMessage(), dataOut, bs);
            if (wireFormat.isStackTraceEnabled()) {
                StackTraceElement[] stackTrace = o.getStackTrace();
                dataOut.writeShort(stackTrace.length);
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement element = stackTrace[i];
                    this.writeString(element.getClassName(), dataOut, bs);
                    this.writeString(element.getMethodName(), dataOut, bs);
                    this.writeString(element.getFileName(), dataOut, bs);
                    dataOut.writeInt(element.getLineNumber());
                }
                this.marshalThrowable(wireFormat, o.getCause(), dataOut, bs);
            }
        }
    }

    protected String readString(DataInputStream dataIn, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            if (bs.readBoolean()) {
                short size = dataIn.readShort();
                byte[] data = new byte[size];
                dataIn.readFully(data);
                return new String(data, 0);
            }
            return dataIn.readUTF();
        }
        return null;
    }

    protected int writeString(String value, BooleanStream bs) throws IOException {
        bs.writeBoolean(value != null);
        if (value != null) {
            int strlen = value.length();
            int utflen = 0;
            char[] charr = new char[strlen];
            boolean count = false;
            boolean isOnlyAscii = true;
            value.getChars(0, strlen, charr, 0);
            for (int i = 0; i < strlen; ++i) {
                char c = charr[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    isOnlyAscii = false;
                    continue;
                }
                isOnlyAscii = false;
                utflen += 2;
            }
            if (utflen >= Short.MAX_VALUE) {
                throw new IOException("Encountered a String value that is too long to encode.");
            }
            bs.writeBoolean(isOnlyAscii);
            return utflen + 2;
        }
        return 0;
    }

    protected void writeString(String value, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            if (bs.readBoolean()) {
                dataOut.writeShort(value.length());
                dataOut.writeBytes(value);
            } else {
                dataOut.writeUTF(value);
            }
        }
    }

    protected int marshalObjectArray(OpenWireFormat wireFormat, DataStructure[] objects, BooleanStream bs) throws IOException {
        if (objects != null) {
            int rc = 0;
            bs.writeBoolean(true);
            rc += 2;
            for (int i = 0; i < objects.length; ++i) {
                rc += this.marshal1NestedObject(wireFormat, objects[i], bs);
            }
            return rc;
        }
        bs.writeBoolean(false);
        return 0;
    }

    protected void marshalObjectArray(OpenWireFormat wireFormat, DataStructure[] objects, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            dataOut.writeShort(objects.length);
            for (int i = 0; i < objects.length; ++i) {
                this.marshal2NestedObject(wireFormat, objects[i], dataOut, bs);
            }
        }
    }

    static {
        Constructor constructor = null;
        try {
            constructor = StackTraceElement.class.getConstructor(String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        STACK_TRACE_ELEMENT_CONSTRUCTOR = constructor;
    }
}

