/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import org.activemq.filter.BinaryExpression;
import org.activemq.filter.Expression;
import org.activemq.filter.MessageEvaluationContext;
import org.activemq.filter.UnaryExpression;

public class MultiExpressionEvaluator {
    HashMap rootExpressions = new HashMap();
    HashMap cachedExpressions = new HashMap();
    int view = 0;

    public void addExpressionListner(Expression selector, ExpressionListener c) {
        ExpressionListenerSet data = (ExpressionListenerSet)this.rootExpressions.get(selector.toString());
        if (data == null) {
            data = new ExpressionListenerSet();
            data.expression = this.addToCache(selector);
            this.rootExpressions.put(selector.toString(), data);
        }
        data.listeners.add(c);
    }

    public boolean removeEventListner(String selector, ExpressionListener c) {
        String expKey = selector;
        ExpressionListenerSet d = (ExpressionListenerSet)this.rootExpressions.get(expKey);
        if (d == null) {
            return false;
        }
        if (!d.listeners.remove(c)) {
            return false;
        }
        if (d.listeners.size() == 0) {
            this.removeFromCache((CacheExpression)d.expression);
            this.rootExpressions.remove(expKey);
        }
        return true;
    }

    private CacheExpression addToCache(Expression expr) {
        CacheExpression n = (CacheExpression)this.cachedExpressions.get(expr);
        if (n == null) {
            n = new CacheExpression(expr);
            this.cachedExpressions.put(expr, n);
            if (expr instanceof UnaryExpression) {
                UnaryExpression un = (UnaryExpression)expr;
                un.setRight(this.addToCache(un.getRight()));
            } else if (expr instanceof BinaryExpression) {
                BinaryExpression bn = (BinaryExpression)expr;
                bn.setRight(this.addToCache(bn.getRight()));
                bn.setLeft(this.addToCache(bn.getLeft()));
            }
        }
        n.refCount = (short)(n.refCount + 1);
        return n;
    }

    private void removeFromCache(CacheExpression cn) {
        cn.refCount = (short)(cn.refCount - 1);
        Expression realExpr = cn.getRight();
        if (cn.refCount == 0) {
            this.cachedExpressions.remove(realExpr);
        }
        if (realExpr instanceof UnaryExpression) {
            UnaryExpression un = (UnaryExpression)realExpr;
            this.removeFromCache((CacheExpression)un.getRight());
        }
        if (realExpr instanceof BinaryExpression) {
            BinaryExpression bn = (BinaryExpression)realExpr;
            this.removeFromCache((CacheExpression)bn.getRight());
        }
    }

    public void evaluate(MessageEvaluationContext message) {
        Collection expressionListeners = this.rootExpressions.values();
        Iterator iter = expressionListeners.iterator();
        while (iter.hasNext()) {
            ExpressionListenerSet els = (ExpressionListenerSet)iter.next();
            try {
                Object result = els.expression.evaluate(message);
                Iterator iterator = els.listeners.iterator();
                while (iterator.hasNext()) {
                    ExpressionListener l = (ExpressionListener)iterator.next();
                    l.evaluateResultEvent(els.expression, message, result);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static interface ExpressionListener {
        public void evaluateResultEvent(Expression var1, MessageEvaluationContext var2, Object var3);
    }

    static class ExpressionListenerSet {
        Expression expression;
        ArrayList listeners = new ArrayList();

        ExpressionListenerSet() {
        }
    }

    public class CacheExpression
    extends UnaryExpression {
        short refCount;
        int cview;
        Object cachedValue;
        int cachedHashCode;

        public CacheExpression(Expression realExpression) {
            super(realExpression);
            this.refCount = 0;
            this.cview = MultiExpressionEvaluator.this.view - 1;
            this.cachedHashCode = realExpression.hashCode();
        }

        public Object evaluate(MessageEvaluationContext message) throws JMSException {
            if (MultiExpressionEvaluator.this.view == this.cview) {
                return this.cachedValue;
            }
            this.cachedValue = this.right.evaluate(message);
            this.cview = MultiExpressionEvaluator.this.view;
            return this.cachedValue;
        }

        public int hashCode() {
            return this.cachedHashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return ((CacheExpression)o).right.equals(this.right);
        }

        public String getExpressionSymbol() {
            return null;
        }

        public String toString() {
            return this.right.toString();
        }
    }
}

