/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BaseCommand;
import org.activemq.command.ConsumerId;
import org.activemq.command.MessageDispatch;
import org.activemq.command.MessageId;
import org.activemq.command.Response;
import org.activemq.command.TransactionId;
import org.activemq.state.CommandVisitor;

public class MessageAck
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 22;
    public static final byte DELIVERED_ACK_TYPE = 0;
    public static final byte STANDARD_ACK_TYPE = 2;
    public static final byte POSION_ACK_TYPE = 1;
    protected byte ackType;
    protected ConsumerId consumerId;
    protected MessageId firstMessageId;
    protected MessageId lastMessageId;
    protected ActiveMQDestination destination;
    protected TransactionId transactionId;
    protected int messageCount;
    protected transient String consumerKey;

    public MessageAck() {
    }

    public MessageAck(MessageDispatch md, byte ackType, int messageCount) {
        this.ackType = ackType;
        this.consumerId = md.getConsumerId();
        this.destination = md.getDestination();
        this.lastMessageId = md.getMessage().getMessageId();
        this.messageCount = messageCount;
    }

    public void copy(MessageAck copy) {
        super.copy(copy);
        copy.firstMessageId = this.firstMessageId;
        copy.lastMessageId = this.lastMessageId;
        copy.destination = this.destination;
        copy.transactionId = this.transactionId;
        copy.ackType = this.ackType;
        copy.consumerId = this.consumerId;
    }

    public byte getDataStructureType() {
        return 22;
    }

    public boolean isPoisonAck() {
        return this.ackType == 1;
    }

    public boolean isStandardAck() {
        return this.ackType == 2;
    }

    public boolean isDeliveredAck() {
        return this.ackType == 0;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(TransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(ConsumerId consumerId) {
        this.consumerId = consumerId;
    }

    public byte getAckType() {
        return this.ackType;
    }

    public void setAckType(byte ackType) {
        this.ackType = ackType;
    }

    public MessageId getFirstMessageId() {
        return this.firstMessageId;
    }

    public void setFirstMessageId(MessageId firstMessageId) {
        this.firstMessageId = firstMessageId;
    }

    public MessageId getLastMessageId() {
        return this.lastMessageId;
    }

    public void setLastMessageId(MessageId lastMessageId) {
        this.lastMessageId = lastMessageId;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public Response visit(CommandVisitor visitor) throws Throwable {
        return visitor.processMessageAck(this);
    }
}

