/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import org.activemq.command.DataStructure;
import org.activemq.command.SessionId;

public class ConsumerId
implements DataStructure {
    public static final byte DATA_STRUCTURE_TYPE = 122;
    protected String connectionId;
    protected long sessionId;
    protected long consumerId;
    protected transient int hashCode;
    protected transient String key;
    protected transient SessionId parentId;

    public ConsumerId() {
    }

    public ConsumerId(SessionId sessionId, long consumerId) {
        this.connectionId = sessionId.getConnectionId();
        this.sessionId = sessionId.getSessionId();
        this.consumerId = consumerId;
    }

    public ConsumerId(ConsumerId id) {
        this.connectionId = id.getConnectionId();
        this.sessionId = id.getSessionId();
        this.consumerId = id.getConsumerId();
    }

    public SessionId getParentId() {
        if (this.parentId == null) {
            this.parentId = new SessionId(this);
        }
        return this.parentId;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.connectionId.hashCode() ^ (int)this.sessionId ^ (int)this.consumerId;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != ConsumerId.class) {
            return false;
        }
        ConsumerId id = (ConsumerId)o;
        return this.sessionId == id.sessionId && this.consumerId == id.consumerId && this.connectionId.equals(id.connectionId);
    }

    public byte getDataStructureType() {
        return 122;
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.connectionId + ":" + this.sessionId + ":" + this.consumerId;
        }
        return this.key;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public long getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(long consumerId) {
        this.consumerId = consumerId;
    }

    public boolean isMarshallAware() {
        return false;
    }
}

