/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import javax.jms.InvalidSelectorException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.IndirectMessageReference;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.PrefetchSubscription;
import org.activemq.broker.region.Queue;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.MessageAck;
import org.activemq.transaction.Synchronization;

public class QueueSubscription
extends PrefetchSubscription {
    public QueueSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(context, info);
    }

    public void add(MessageReference node) throws Throwable {
        super.add(node);
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
        final IndirectMessageReference node = (IndirectMessageReference)n;
        final Queue queue = (Queue)node.getRegionDestination();
        queue.acknowledge(context, this, ack, node);
        if (!ack.isInTransaction()) {
            node.drop();
            queue.dropEvent();
        } else {
            node.setAcked(true);
            context.getTransaction().addSynchronization(new Synchronization(){

                public void afterCommit() throws Throwable {
                    node.drop();
                    queue.dropEvent();
                }

                public void afterRollback() throws Throwable {
                    node.setAcked(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canDispatch(MessageReference n) {
        IndirectMessageReference node = (IndirectMessageReference)n;
        if (node.isAcked()) {
            return false;
        }
        String groupId = node.getGroupID();
        int sequence = node.getGroupSequence();
        if (groupId != null) {
            ConsumerId groupOwner;
            ConcurrentHashMap messageGroupOwners = ((Queue)node.getRegionDestination()).getMessageGroupOwners();
            if (sequence == 1) {
                if (node.lock(this)) {
                    messageGroupOwners.put((Object)groupId, (Object)this.info.getConsumerId());
                    return true;
                }
                return false;
            }
            IndirectMessageReference indirectMessageReference = node;
            synchronized (indirectMessageReference) {
                groupOwner = (ConsumerId)messageGroupOwners.get((Object)groupId);
                if (groupOwner == null) {
                    if (node.lock(this)) {
                        messageGroupOwners.put((Object)groupId, (Object)this.info.getConsumerId());
                        return true;
                    }
                    return false;
                }
            }
            if (groupOwner.equals(this.info.getConsumerId())) {
                if (sequence < 1) {
                    messageGroupOwners.remove((Object)groupId);
                }
                return true;
            }
            return false;
        }
        return node.lock(this);
    }

    public String toString() {
        return "QueueSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.delivered + ", matched=" + this.matched.size();
    }
}

