/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.Iterator;
import javax.jms.InvalidSelectorException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.PrefetchSubscription;
import org.activemq.broker.region.Topic;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageDispatch;

public class DurableTopicSubscription
extends PrefetchSubscription {
    protected final String clientId;
    protected final String subscriptionName;
    final ConcurrentHashMap redeliveredMessages = new ConcurrentHashMap();
    boolean active = true;
    boolean recovered = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DurableTopicSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(context, info);
        this.clientId = context.getClientId();
        this.subscriptionName = info.getSubcriptionName();
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized boolean isRecovered() {
        return this.recovered;
    }

    protected boolean isFull() {
        return !this.active || super.isFull();
    }

    public synchronized void gc() {
        if (!this.active && this.recovered) {
            MessageReference node;
            this.recovered = false;
            Iterator iter = this.dispatched.iterator();
            while (iter.hasNext()) {
                node = (MessageReference)iter.next();
                iter.remove();
            }
            iter = this.matched.iterator();
            while (iter.hasNext()) {
                node = (MessageReference)iter.next();
                iter.remove();
            }
            this.delivered = 0;
        }
    }

    public synchronized void deactivate() {
        this.active = false;
        Iterator iter = this.dispatched.iterator();
        while (iter.hasNext()) {
            MessageReference node = (MessageReference)iter.next();
            Integer count = (Integer)this.redeliveredMessages.get((Object)node.getMessageId());
            if (count != null) {
                this.redeliveredMessages.put((Object)node.getMessageId(), (Object)new Integer(count + 1));
            } else {
                this.redeliveredMessages.put((Object)node.getMessageId(), (Object)new Integer(1));
            }
            this.matched.addFirst(node);
            iter.remove();
        }
        this.delivered = 0;
    }

    public synchronized void activate(ConnectionContext context, ConsumerInfo info) throws Throwable {
        if (!this.active) {
            this.active = true;
            this.context = context;
            this.info = info;
            if (!this.recovered) {
                this.recovered = true;
                Iterator iter = this.destinations.iterator();
                while (iter.hasNext()) {
                    Topic topic = (Topic)iter.next();
                    topic.recover(this, false);
                }
            } else if (!this.isFull()) {
                this.dispatchMatched();
            }
        }
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        MessageDispatch md = super.createMessageDispatch(node, message);
        Integer count = (Integer)this.redeliveredMessages.get((Object)node.getMessageId());
        if (count != null) {
            md.setRedeliveryCounter(count);
        }
        return md;
    }

    public synchronized void add(MessageReference node) throws Throwable {
        if (!$assertionsDisabled && !this.recovered) {
            throw new AssertionError();
        }
        super.add(node);
    }

    protected boolean canDispatch(MessageReference node) {
        return this.active;
    }

    public synchronized void acknowledge(ConnectionContext context, MessageAck ack) throws Throwable {
        if (!$assertionsDisabled && !this.recovered) {
            throw new AssertionError();
        }
        super.acknowledge(context, ack);
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
        node.getRegionDestination().acknowledge(context, this, ack, node);
        this.redeliveredMessages.remove((Object)node.getMessageId());
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String toString() {
        return "DurableTopicSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.delivered + ", matched=" + this.matched.size();
    }

    public String getClientId() {
        return this.clientId;
    }

    static {
        $assertionsDisabled = !DurableTopicSubscription.class.desiredAssertionStatus();
    }
}

