/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.activemq.broker.Broker;
import org.activemq.broker.Connection;
import org.activemq.broker.TransportConnection;
import org.activemq.broker.TransportConnector;
import org.activemq.broker.jmx.ConnectionView;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportServer;
import org.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedTransportConnector
extends TransportConnector {
    private static final Log log = LogFactory.getLog((Class)ManagedTransportConnector.class);
    private final MBeanServer mbeanServer;
    private final ObjectName connectorName;
    long nextConnectionId = 1L;

    public ManagedTransportConnector(MBeanServer mbeanServer, ObjectName connectorName, Broker next, TransportServer server) {
        super(next, server);
        this.mbeanServer = mbeanServer;
        this.connectorName = connectorName;
    }

    public ManagedTransportConnector asManagedConnector(MBeanServer mbeanServer, ObjectName connectorName) throws IOException, URISyntaxException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection createConnection(Transport transport) throws IOException {
        ObjectName destObjectName;
        String connectionId;
        ManagedTransportConnector managedTransportConnector = this;
        synchronized (managedTransportConnector) {
            connectionId = "" + this.nextConnectionId++;
        }
        Hashtable<String, String> map = new Hashtable<String, String>(this.connectorName.getKeyPropertyList());
        map.put("Type", "Connection");
        map.put("Connection", connectionId);
        try {
            destObjectName = new ObjectName(this.connectorName.getDomain(), map);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
        TransportConnection rc = new TransportConnection(this, transport, this.getBrokerFilter(), this.getTaskRunnerFactory()){

            public void stop() throws Exception {
                try {
                    ManagedTransportConnector.this.mbeanServer.unregisterMBean(destObjectName);
                }
                catch (Throwable e) {
                    log.warn((Object)("Failed to unregister mbean: " + destObjectName));
                }
                super.stop();
            }
        };
        ConnectionView view = new ConnectionView(rc);
        try {
            this.mbeanServer.registerMBean(view, destObjectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
        return rc;
    }
}

