/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import org.activemq.broker.ConnectionContext;
import org.activemq.broker.jmx.ManagedRegionBroker;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.TempTopicRegion;
import org.activemq.command.ActiveMQDestination;
import org.activemq.memory.UsageManager;
import org.activemq.thread.TaskRunnerFactory;

public class ManagedTempTopicRegion
extends TempTopicRegion {
    private final ManagedRegionBroker regionBroker;

    public ManagedTempTopicRegion(ManagedRegionBroker regionBroker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        super(destinationStatistics, memoryManager, taskRunnerFactory);
        this.regionBroker = regionBroker;
    }

    protected Destination createDestination(ActiveMQDestination destination) throws Throwable {
        Destination rc = super.createDestination(destination);
        this.regionBroker.register(destination, rc);
        return rc;
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Throwable {
        super.removeDestination(context, destination, timeout);
        this.regionBroker.unregister(destination);
    }
}

