/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.activemq.Service;
import org.activemq.broker.Broker;
import org.activemq.broker.Connection;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.Connector;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BrokerInfo;
import org.activemq.command.Command;
import org.activemq.command.ConnectionId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.DataArrayResponse;
import org.activemq.command.DataStructure;
import org.activemq.command.DestinationInfo;
import org.activemq.command.ExceptionResponse;
import org.activemq.command.KeepAliveInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageDispatch;
import org.activemq.command.ProducerId;
import org.activemq.command.ProducerInfo;
import org.activemq.command.RemoveSubscriptionInfo;
import org.activemq.command.Response;
import org.activemq.command.SessionId;
import org.activemq.command.SessionInfo;
import org.activemq.command.ShutdownInfo;
import org.activemq.command.TransactionInfo;
import org.activemq.command.WireFormatInfo;
import org.activemq.state.CommandVisitor;
import org.activemq.state.ConsumerState;
import org.activemq.state.ProducerState;
import org.activemq.state.SessionState;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConnection
implements Service,
Connection,
Task,
CommandVisitor {
    private static final Log log = LogFactory.getLog((Class)AbstractConnection.class);
    protected final Broker broker;
    protected final List dispatchQueue = Collections.synchronizedList(new LinkedList());
    protected final TaskRunner taskRunner;
    protected final Connector connector;
    protected final ConcurrentHashMap connectionStates = new ConcurrentHashMap();
    private WireFormatInfo wireFormatInfo;
    protected boolean disposed = false;

    public AbstractConnection(Connector connector, Broker broker, TaskRunnerFactory taskRunnerFactory) {
        this.connector = connector;
        this.broker = broker;
        this.taskRunner = taskRunnerFactory != null ? taskRunnerFactory.createTaskRunner(this) : null;
    }

    public void start() throws Exception {
        this.dispatch(this.connector.getBrokerInfo());
    }

    public void stop() throws Exception {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        ArrayList l = new ArrayList(this.connectionStates.keySet());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            ConnectionId connectionId = (ConnectionId)iter.next();
            try {
                this.processRemoveConnection(connectionId);
            }
            catch (Throwable ignore) {}
        }
    }

    public void serviceTransportException(IOException e) {
        if (!this.disposed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Transport failed: " + e), (Throwable)e);
            }
            log.debug((Object)("Transport failed: " + e), (Throwable)e);
            ServiceSupport.dispose(this);
        }
    }

    public void serviceException(Throwable e) {
        if (!this.disposed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Async error occurred: " + e), e);
            }
            e.printStackTrace();
        }
    }

    public Response service(Command command) {
        Response response = null;
        boolean responseRequired = command.isResponseRequired();
        short commandId = command.getCommandId();
        try {
            response = command.visit(this);
        }
        catch (Throwable e) {
            if (responseRequired) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sync error occurred: " + e), e);
                }
                response = new ExceptionResponse(e);
            }
            this.serviceException(e);
        }
        if (responseRequired) {
            if (response == null) {
                response = new Response();
            }
            response.setCorrelationId(commandId);
        }
        return response;
    }

    protected ConnectionState lookupConnectionState(ConsumerId id) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)id.getParentId().getParentId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a consumer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    protected ConnectionState lookupConnectionState(ProducerId id) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)id.getParentId().getParentId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a producer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    protected ConnectionState lookupConnectionState(SessionId id) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)id.getParentId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a session from a connection that had not been registered: " + id.getParentId());
        }
        return cs;
    }

    protected ConnectionState lookupConnectionState(ConnectionId connectionId) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a connection that had not been registered: " + connectionId);
        }
        return cs;
    }

    public Response processKeepAlive(KeepAliveInfo info) throws Throwable {
        return null;
    }

    public Response processRemoveSubscription(RemoveSubscriptionInfo info) throws Throwable {
        this.broker.removeSubscription(this.lookupConnectionState(info.getConnectionId()).getContext(), info);
        return null;
    }

    public Response processWireFormat(WireFormatInfo info) throws Throwable {
        this.wireFormatInfo = info;
        return null;
    }

    public Response processShutdown(ShutdownInfo info) throws Throwable {
        this.stop();
        return null;
    }

    public Response processBeginTransaction(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.beginTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processEndTransaction(TransactionInfo info) throws Throwable {
        return null;
    }

    public Response processPrepareTransaction(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.prepareTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processCommitTransactionOnePhase(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.commitTransaction(context, info.getTransactionId(), true);
        return null;
    }

    public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.commitTransaction(context, info.getTransactionId(), false);
        return null;
    }

    public Response processRollbackTransaction(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.rollbackTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processForgetTransaction(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.forgetTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processRecoverTransactions(TransactionInfo info) throws Throwable {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        DataStructure[] preparedTransactions = this.broker.getPreparedTransactions(context);
        return new DataArrayResponse(preparedTransactions);
    }

    public Response processMessage(Message messageSend) throws Throwable {
        this.broker.send(this.lookupConnectionState(messageSend.getProducerId()).getContext(), messageSend);
        return null;
    }

    public Response processMessageAck(MessageAck ack) throws Throwable {
        this.broker.acknowledge(this.lookupConnectionState(ack.getConsumerId()).getContext(), ack);
        return null;
    }

    public Response processBrokerInfo(BrokerInfo info) {
        return null;
    }

    public Response processAddDestination(DestinationInfo info) throws Throwable {
        ConnectionState cs = this.lookupConnectionState(info.getConnectionId());
        this.broker.addDestination(cs.getContext(), info.getDestination());
        if (info.getDestination().isTemporary()) {
            cs.addTempDestination(info.getDestination());
        }
        return null;
    }

    public Response processRemoveDestination(DestinationInfo info) throws Throwable {
        ConnectionState cs = this.lookupConnectionState(info.getConnectionId());
        this.broker.removeDestination(cs.getContext(), info.getDestination(), info.getTimeout());
        if (info.getDestination().isTemporary()) {
            cs.removeTempDestination(info.getDestination());
        }
        return null;
    }

    public Response processAddProducer(ProducerInfo info) throws Throwable {
        SessionId sessionId = info.getProducerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot add a producer to a session that had not been registered: " + sessionId);
        }
        this.broker.addProducer(cs.getContext(), info);
        ss.addProducer(info);
        return null;
    }

    public Response processRemoveProducer(ProducerId id) throws Throwable {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a producer from a session that had not been registered: " + sessionId);
        }
        ProducerState ps = ss.removeProducer(id);
        if (ps == null) {
            throw new IllegalStateException("Cannot remove a producer that had not been registered: " + id);
        }
        this.broker.removeProducer(cs.getContext(), ps.getInfo());
        return null;
    }

    public Response processAddConsumer(ConsumerInfo info) throws Throwable {
        SessionId sessionId = info.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot add a consumer to a session that had not been registered: " + sessionId);
        }
        this.broker.addConsumer(cs.getContext(), info);
        ss.addConsumer(info);
        return null;
    }

    public Response processRemoveConsumer(ConsumerId id) throws Throwable {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + sessionId);
        }
        ConsumerState consumerState = ss.removeConsumer(id);
        if (consumerState == null) {
            throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + id);
        }
        this.broker.removeConsumer(cs.getContext(), consumerState.getInfo());
        return null;
    }

    public Response processAddSession(SessionInfo info) throws Throwable {
        ConnectionId connectionId = info.getSessionId().getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        this.broker.addSession(cs.getContext(), info);
        cs.addSession(info);
        return null;
    }

    public Response processRemoveSession(SessionId id) throws Throwable {
        ConnectionId connectionId = id.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState session = cs.getSessionState(id);
        if (session == null) {
            throw new IllegalStateException("Cannot remove session that had not been registered: " + id);
        }
        Iterator iter = session.getConsumerIds().iterator();
        while (iter.hasNext()) {
            this.processRemoveConsumer((ConsumerId)iter.next());
        }
        iter = session.getProducerIds().iterator();
        while (iter.hasNext()) {
            this.processRemoveProducer((ProducerId)iter.next());
        }
        cs.removeSession(id);
        this.broker.removeSession(cs.getContext(), session.getInfo());
        return null;
    }

    public Response processAddConnection(ConnectionInfo info) throws Throwable {
        ConnectionContext context = new ConnectionContext();
        context.setConnection(this);
        context.setBroker(this.broker);
        context.setConnector(this.connector);
        context.setTransactions(new ConcurrentHashMap());
        context.setClientId(info.getClientId());
        context.setUserName(info.getUserName());
        context.setConnectionId(info.getConnectionId());
        context.setWireFormatInfo(this.wireFormatInfo);
        this.connectionStates.put((Object)info.getConnectionId(), (Object)new ConnectionState(info, context));
        this.broker.addConnection(context, info);
        return null;
    }

    public Response processRemoveConnection(ConnectionId id) throws Throwable {
        ConnectionState cs = this.lookupConnectionState(id);
        Iterator iter = cs.getSessionIds().iterator();
        while (iter.hasNext()) {
            this.processRemoveSession((SessionId)iter.next());
        }
        iter = cs.getTempDesinations().iterator();
        while (iter.hasNext()) {
            this.broker.removeDestination(cs.getContext(), (ActiveMQDestination)iter.next(), 0L);
            iter.remove();
        }
        this.broker.removeConnection(cs.getContext(), cs.getInfo(), null);
        this.connectionStates.remove((Object)id);
        return null;
    }

    public Connector getConnector() {
        return this.connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchSync(Command command) {
        if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            Runnable sub = (Runnable)md.getConsumer();
            try {
                this.dispatch(command);
            }
            finally {
                if (sub != null) {
                    sub.run();
                }
            }
        } else {
            this.dispatch(command);
        }
    }

    public void dispatchAsync(Command message) {
        if (this.taskRunner == null) {
            this.dispatchSync(message);
        } else {
            this.dispatchQueue.add(message);
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean iterate() {
        if (this.dispatchQueue.isEmpty()) {
            return false;
        }
        Command command = (Command)this.dispatchQueue.remove(0);
        this.dispatch(command);
        return true;
    }

    public boolean isSlow() {
        return false;
    }

    public boolean isBlocked() {
        return false;
    }

    public boolean isConnected() {
        return !this.disposed;
    }

    public boolean isActive() {
        return !this.disposed;
    }

    protected abstract void dispatch(Command var1);

    static class ConnectionState
    extends org.activemq.state.ConnectionState {
        private final ConnectionContext context;

        public ConnectionState(ConnectionInfo info, ConnectionContext context) {
            super(info);
            this.context = context;
        }

        public ConnectionContext getContext() {
            return this.context;
        }
    }
}

