/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQPrefetchPolicy;
import org.activemq.ConfigurationException;
import org.activemq.management.JMSStatsImpl;
import org.activemq.management.StatsCapable;
import org.activemq.management.StatsImpl;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.util.JMSExceptionSupport;

public class ActiveMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
StatsCapable {
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    public static final String DEFAULT_USER = null;
    public static final String DEFAULT_PASSWORD = null;
    protected URI brokerURL;
    protected String userName;
    protected String password;
    protected String clientID;
    protected boolean useEmbeddedBroker;
    private boolean useRetroactiveConsumer;
    protected boolean useAsyncSend = true;
    protected boolean prepareMessageBodyOnSend = true;
    protected boolean copyMessageOnSend = true;
    protected boolean cachingEnabled = true;
    protected boolean optimizedMessageDispatch = false;
    protected boolean disableTimeStampsByDefault = false;
    private ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
    JMSStatsImpl factoryStats = new JMSStatsImpl();
    protected static final Executor DEFAULT_CONNECTION_EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

        public Thread newThread(Runnable run) {
            Thread thread = new Thread(run);
            thread.setPriority(7);
            return thread;
        }
    });

    public ActiveMQConnectionFactory() {
        this(DEFAULT_BROKER_URL);
    }

    public ActiveMQConnectionFactory(String brokerURL) {
        this(ActiveMQConnectionFactory.createURI(brokerURL));
    }

    private static URI createURI(String brokerURL) {
        try {
            return new URI(brokerURL);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid broker URI: " + brokerURL).initCause(e);
        }
    }

    public ActiveMQConnectionFactory(URI brokerURL) {
        this.setBrokerURL(brokerURL.toString());
    }

    public ActiveMQConnectionFactory(String userName, String password, URI brokerURL) {
        this.setUserName(userName);
        this.setPassword(password);
        this.setBrokerURL(brokerURL.toString());
    }

    public ActiveMQConnectionFactory(String userName, String password, String brokerURL) {
        this.setUserName(userName);
        this.setPassword(password);
        this.setBrokerURL(brokerURL);
    }

    public Connection createConnection() throws JMSException {
        return this.createActiveMQConnection(this.userName, this.password);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createActiveMQConnection(this.userName, this.password);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createActiveMQConnection(this.userName, this.password);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    public StatsImpl getStats() {
        return null;
    }

    private ActiveMQConnection createActiveMQConnection(String userName, String password) throws JMSException {
        if (this.brokerURL == null) {
            throw new ConfigurationException("brokerURL not set.");
        }
        try {
            Transport transport = TransportFactory.connect(this.brokerURL, DEFAULT_CONNECTION_EXECUTOR);
            ActiveMQConnection connection = new ActiveMQConnection(transport, userName, password, this.factoryStats);
            connection.setUseRetroactiveConsumer(this.isUseRetroactiveConsumer());
            return connection;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Could not connect to broker URL: " + this.brokerURL + ". Reason: " + e, e);
        }
    }

    public String getBrokerURL() {
        return this.brokerURL == null ? null : this.brokerURL.toString();
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = ActiveMQConnectionFactory.createURI(brokerURL);
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean disableTimeStampsByDefault) {
        this.disableTimeStampsByDefault = disableTimeStampsByDefault;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean optimizedMessageDispatch) {
        this.optimizedMessageDispatch = optimizedMessageDispatch;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public boolean isPrepareMessageBodyOnSend() {
        return this.prepareMessageBodyOnSend;
    }

    public void setPrepareMessageBodyOnSend(boolean prepareMessageBodyOnSend) {
        this.prepareMessageBodyOnSend = prepareMessageBodyOnSend;
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public boolean isUseEmbeddedBroker() {
        return this.useEmbeddedBroker;
    }

    public void setUseEmbeddedBroker(boolean useEmbeddedBroker) {
        this.useEmbeddedBroker = useEmbeddedBroker;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isUseRetroactiveConsumer() {
        return this.useRetroactiveConsumer;
    }

    public void setUseRetroactiveConsumer(boolean useRetroactiveConsumer) {
        this.useRetroactiveConsumer = useRetroactiveConsumer;
    }

    public void setProperties(Properties properties) throws URISyntaxException {
        if (properties == null) {
            properties = new Properties();
        }
        this.setUserName(properties.getProperty("userName", this.userName));
        this.setPassword(properties.getProperty("password", this.password));
        this.setClientID(properties.getProperty("clientID"));
        String temp = properties.getProperty("java.naming.provider.url");
        if (temp == null || temp.length() == 0) {
            temp = properties.getProperty("brokerURL");
        }
        if (temp != null && temp.length() > 0) {
            this.setBrokerURL(temp);
        }
        if ((temp = properties.getProperty("useRetroactiveConsumer")) != null && temp.equalsIgnoreCase("true")) {
            this.setUseRetroactiveConsumer(true);
        }
    }
}

