/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.util.Properties;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ConsumerInfo;
import org.activemq.transport.stomp.Command;
import org.activemq.transport.stomp.DestinationNamer;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.PacketEnvelope;
import org.activemq.transport.stomp.StompWireFormat;
import org.activemq.transport.stomp.Subscription;

class Subscribe
implements Command {
    private HeaderParser headerParser = new HeaderParser();
    private StompWireFormat format;

    Subscribe(StompWireFormat format) {
        this.format = format;
    }

    public PacketEnvelope build(String commandLine, DataInput in) throws IOException {
        ConsumerInfo ci = new ConsumerInfo();
        Properties headers = this.headerParser.parse(in);
        String destination = headers.getProperty("destination");
        ActiveMQDestination actual_dest = DestinationNamer.convert(destination);
        ci.setDestination(DestinationNamer.convert(destination));
        ci.setStarted(true);
        ci.setStartTime(System.currentTimeMillis());
        ci.setClientId(this.format.getClientId());
        short consumer_no = StompWireFormat.clientIds.getNextShortSequence();
        ci.setConsumerNo(consumer_no);
        ci.setReceiptRequired(true);
        ci.setSessionId(this.format.getSessionId());
        while (in.readByte() != 0) {
        }
        String consumerId = StompWireFormat.clientIds.generateId();
        ci.setConsumerId(consumerId);
        String subscriptionId = headers.getProperty("id", "~~ NO SUCH THING ~~%%@#!Q");
        Subscription s = new Subscription(this.format, consumer_no, consumerId, subscriptionId);
        s.setDestination(actual_dest);
        String ack_mode_key = headers.getProperty("ack");
        if (ack_mode_key != null && ack_mode_key.equals("client")) {
            s.setAckMode(2);
        }
        this.format.addSubscription(s);
        return new PacketEnvelope(ci, headers);
    }
}

