/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.peer;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.activemq.broker.BrokerConnector;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerConnectorImpl;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.activemq.io.WireFormat;
import org.activemq.store.vm.VMPersistenceAdapter;
import org.activemq.transport.DiscoveryNetworkConnector;
import org.activemq.transport.NetworkConnector;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.multicast.MulticastDiscoveryAgent;
import org.activemq.transport.vm.VmTransportChannel;
import org.activemq.util.IdGenerator;
import org.activemq.util.URIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeerTransportChannel
extends VmTransportChannel {
    private static final Log log = LogFactory.getLog((Class)PeerTransportChannel.class);
    protected static final String DEFAULT_BROKER_CONNECTOR_URI = "tcp://localhost:0";
    protected WireFormat wireFormat;
    protected TransportChannel channel;
    protected String discoveryURI;
    protected String remoteUserName;
    protected String remotePassword;
    protected String brokerName;
    protected boolean doDiscovery;
    protected String peerURIs;
    protected String brokerConnectorURI;
    protected String serviceName;
    protected BrokerConnector brokerConnector;
    protected boolean remote;
    protected boolean persistent = false;

    protected PeerTransportChannel(WireFormat wireFormat, String serviceName) throws JMSException {
        this.wireFormat = wireFormat;
        this.serviceName = serviceName;
        this.discoveryURI = "multicast://224.1.2.3:6066";
        IdGenerator idGen = new IdGenerator();
        this.brokerName = idGen.generateId();
        this.brokerConnectorURI = DEFAULT_BROKER_CONNECTOR_URI;
        this.doDiscovery = true;
        if (serviceName == null || serviceName.length() == 0) {
            throw new IllegalStateException("No service name specified for peer:// protocol");
        }
    }

    public boolean isTransportConnected() {
        return true;
    }

    public boolean requiresEmbeddedBroker() {
        return true;
    }

    public BrokerConnector getEmbeddedBrokerConnector() throws JMSException {
        try {
            if (this.brokerConnector == null) {
                BrokerContainerImpl container = new BrokerContainerImpl(this.brokerName, this.serviceName);
                if (!this.persistent) {
                    container.setPersistenceAdapter(new VMPersistenceAdapter());
                }
                NetworkConnector networkConnector = null;
                if (this.doDiscovery) {
                    networkConnector = new DiscoveryNetworkConnector(container);
                    MulticastDiscoveryAgent agent = new MulticastDiscoveryAgent(this.serviceName);
                    container.setDiscoveryAgent(agent);
                }
                if (this.peerURIs != null && this.peerURIs.length() > 0) {
                    URIHelper peers = new URIHelper(this.peerURIs);
                    networkConnector = this.createNetworkConnector(container);
                    while (peers.hasNext()) {
                        String peerURL = peers.getNext();
                        networkConnector.addNetworkChannel(peerURL);
                    }
                }
                container.addNetworkConnector(networkConnector);
                URIHelper helper = new URIHelper(this.brokerConnectorURI);
                this.brokerConnector = new BrokerConnectorImpl(container, helper.getNext(), this.wireFormat);
                while (helper.hasNext()) {
                    new BrokerConnectorImpl(container, helper.getNext(), this.wireFormat);
                }
                container.start();
            }
            return this.brokerConnector;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorStr = "Failed to get embedded connector";
            log.error((Object)errorStr, (Throwable)e);
            JMSException jmsEx = new JMSException(errorStr);
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    protected NetworkConnector createNetworkConnector(BrokerContainer container) {
        return new NetworkConnector(container);
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public boolean isDoDiscovery() {
        return this.doDiscovery;
    }

    public void setDoDiscovery(boolean doDiscovery) {
        this.doDiscovery = doDiscovery;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    public String getBrokerConnectorURI() {
        return this.brokerConnectorURI;
    }

    public void setBrokerConnectorURI(String brokerConnectorURI) {
        this.brokerConnectorURI = brokerConnectorURI;
    }

    public String getPeerURIs() {
        return this.peerURIs;
    }

    public void setPeerURIs(String peerURIs) {
        this.peerURIs = peerURIs;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }
}

