/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.composite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportChannelFactorySupport;
import org.activemq.transport.composite.CompositeTransportChannel;
import org.activemq.util.JMSExceptionHelper;

public class CompositeTransportChannelFactory
extends TransportChannelFactorySupport {
    private static String separator = ",";

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            List uris = new ArrayList();
            String text = CompositeTransportChannelFactory.parseURIs(uris, remoteLocation);
            uris = this.randomizeURIs(uris);
            CompositeTransportChannel channel = new CompositeTransportChannel(wireFormat, uris);
            return this.populateProperties((TransportChannel)channel, text);
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException("Can't parse list of URIs for: " + remoteLocation + ". Reason: " + e, e);
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        return this.create(wireFormat, remoteLocation);
    }

    public boolean requiresEmbeddedBroker() {
        return false;
    }

    public static String parseURIs(List uris, URI uri) throws URISyntaxException {
        String answer = "";
        String text = uri.getSchemeSpecificPart();
        if (text.startsWith("(")) {
            int count = 1;
            int size = text.length();
            for (int i = 1; i < size; ++i) {
                char ch = text.charAt(i);
                if (ch == '(') {
                    ++count;
                    continue;
                }
                if (ch != ')' || --count != 0) continue;
                answer = text.substring(i + 1);
                text = text.substring(1, i);
                break;
            }
        } else {
            answer = uri.getQuery();
        }
        StringTokenizer iter = new StringTokenizer(text, separator);
        while (iter.hasMoreTokens()) {
            String child = CompositeTransportChannelFactory.stripLeadingSlashes(iter.nextToken().trim());
            uris.add(new URI(child));
        }
        return answer;
    }

    protected static String stripLeadingSlashes(String text) {
        int idx;
        for (idx = 0; idx < text.length() && text.charAt(idx) == '/'; ++idx) {
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    protected List randomizeURIs(List uris) {
        return uris;
    }
}

