/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.jms.JMSException;
import org.activemq.message.Packet;

public interface WireFormat {
    public static final int DEFAULT_MAXIMUM_MESSAGE_SIZE = 65536;

    public Packet readPacket(DataInput var1) throws IOException;

    public Packet readPacket(int var1, DataInput var2) throws IOException;

    public Packet readPacket(String var1, DatagramPacket var2) throws IOException;

    public Packet writePacket(Packet var1, DataOutput var2) throws IOException, JMSException;

    public DatagramPacket writePacket(String var1, Packet var2) throws IOException, JMSException;

    public Packet fromBytes(byte[] var1, int var2, int var3) throws IOException;

    public Packet fromBytes(byte[] var1) throws IOException;

    public byte[] toBytes(Packet var1) throws IOException, JMSException;

    public WireFormat copy();

    public boolean canProcessWireFormatVersion(int var1);

    public int getCurrentWireFormatVersion();

    public void registerTransportStreams(DataOutputStream var1, DataInputStream var2);

    public void initiateClientSideProtocol() throws IOException;

    public void initiateServerSideProtocol() throws IOException;

    public boolean isCachingEnabled();

    public void setCachingEnabled(boolean var1);

    public boolean doesSupportMessageFragmentation();

    public boolean doesSupportMessageCompression();
}

