/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.BooleanExpression;
import org.activemq.filter.Expression;
import org.activemq.filter.PropertyExpression;
import org.activemq.filter.XPathExpression;
import org.activemq.filter.XQueryExpression;

public abstract class UnaryExpression
implements Expression {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression right;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static Expression createNegate(Expression left) {
        return new UnaryExpression(left){

            public Object evaluate(Message message) throws JMSException {
                Object rvalue = this.right.evaluate(message);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue instanceof Number) {
                    return UnaryExpression.negate((Number)rvalue);
                }
                return null;
            }

            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static BooleanExpression createInExpression(PropertyExpression right, List elements, final boolean not) {
        Collection t = elements.size() == 0 ? null : (elements.size() < 5 ? elements : new HashSet(elements));
        final List inList = t;
        return new BooleanUnaryExpression(right){

            public Object evaluate(Message message) throws JMSException {
                Object rvalue = this.right.evaluate(message);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue.getClass() != (class$java$lang$String == null ? (class$java$lang$String = UnaryExpression.class$("java.lang.String")) : class$java$lang$String)) {
                    return null;
                }
                if ((inList != null && inList.contains(rvalue)) ^ not) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public String toString() {
                StringBuffer answer = new StringBuffer();
                answer.append(this.right);
                answer.append(" ");
                answer.append(this.getExpressionSymbol());
                answer.append(" ( ");
                int count = 0;
                Iterator i = inList.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (count != 0) {
                        answer.append(", ");
                    }
                    answer.append(o);
                    ++count;
                }
                answer.append(" )");
                return answer.toString();
            }

            public String getExpressionSymbol() {
                if (not) {
                    return "NOT IN";
                }
                return "IN";
            }
        };
    }

    public static BooleanExpression createNOT(BooleanExpression left) {
        return new BooleanUnaryExpression(left){

            public Object evaluate(Message message) throws JMSException {
                Boolean lvalue = (Boolean)this.right.evaluate(message);
                if (lvalue == null) {
                    return null;
                }
                return lvalue != false ? Boolean.FALSE : Boolean.TRUE;
            }

            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    public static BooleanExpression createXPath(String xpath) {
        return new XPathExpression(xpath);
    }

    public static BooleanExpression createXQuery(String xpath) {
        return new XQueryExpression(xpath);
    }

    public static BooleanExpression createBooleanCast(Expression left) {
        return new BooleanUnaryExpression(left){

            public Object evaluate(Message message) throws JMSException {
                Object lvalue = this.right.evaluate(message);
                if (lvalue == null) {
                    return null;
                }
                if (!lvalue.getClass().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = UnaryExpression.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return Boolean.FALSE;
                }
                return lvalue;
            }

            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return new Integer(-left.intValue());
        }
        if (clazz == Long.class) {
            return new Long(-left.longValue());
        }
        if (clazz == Float.class) {
            return new Float(-left.floatValue());
        }
        if (clazz == Double.class) {
            return new Double(-left.doubleValue());
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return new Long(Long.MIN_VALUE);
            }
            return bd;
        }
        throw new RuntimeException("Don't know how to negate: " + left);
    }

    public UnaryExpression(Expression left) {
        this.right = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public abstract String getExpressionSymbol();

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        public BooleanUnaryExpression(Expression left) {
            super(left);
        }
    }
}

