/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.activemq.ActiveMQSession;
import org.activemq.Closeable;
import org.activemq.management.JMSProducerStatsImpl;
import org.activemq.management.StatsCapable;
import org.activemq.management.StatsImpl;
import org.activemq.message.ActiveMQDestination;
import org.activemq.util.IdGenerator;

public class ActiveMQMessageProducer
implements MessageProducer,
StatsCapable,
Closeable {
    protected ActiveMQSession session;
    private IdGenerator idGenerator;
    protected boolean closed;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int defaultDeliveryMode;
    private int defaultPriority;
    private long defaultTimeToLive;
    protected ActiveMQDestination defaultDestination;
    private long startTime;
    private JMSProducerStatsImpl stats;
    private short producerId;
    private boolean reuseMessageId;

    protected ActiveMQMessageProducer(ActiveMQSession theSession, ActiveMQDestination destination) throws JMSException {
        this.session = theSession;
        this.defaultDestination = destination;
        this.idGenerator = new IdGenerator();
        this.disableMessageID = false;
        this.disableMessageTimestamp = theSession.connection.isDisableTimeStampsByDefault();
        this.defaultDeliveryMode = 2;
        this.defaultPriority = 4;
        this.defaultTimeToLive = 0L;
        this.startTime = System.currentTimeMillis();
        this.session.addProducer(this);
        this.stats = new JMSProducerStatsImpl(theSession.getSessionStats(), destination);
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSProducerStatsImpl getProducerStats() {
        return this.stats;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int newDeliveryMode) throws JMSException {
        if (newDeliveryMode != 2 && newDeliveryMode != 1) {
            throw new IllegalStateException("unkown delivery mode: " + newDeliveryMode);
        }
        this.checkClosed();
        this.defaultDeliveryMode = newDeliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int newDefaultPriority) throws JMSException {
        if (newDefaultPriority < 0 || newDefaultPriority > 9) {
            throw new IllegalStateException("default priority must be a value between 0 and 9");
        }
        this.checkClosed();
        this.defaultPriority = newDefaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new IllegalStateException("cannot set a negative timeToLive");
        }
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    public void close() throws JMSException {
        this.session.removeProducer(this);
        this.closed = true;
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The producer is closed");
        }
    }

    public void send(Message message) throws JMSException {
        this.send(this.defaultDestination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.defaultDestination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (destination == null) {
            throw new UnsupportedOperationException("Dont understand null destinations");
        }
        if (this.defaultDestination != null && destination != this.defaultDestination && this.session.connection.isJ2EEcompliant()) {
            throw new UnsupportedOperationException("This producer can only send messages to: " + this.defaultDestination.getPhysicalName());
        }
        if (this.defaultDestination == null) {
            this.session.connection.startAdvisoryForTempDestination(destination);
        }
        this.session.send(this, destination, message, deliveryMode, priority, timeToLive, this.reuseMessageId);
        this.stats.onMessage(message);
    }

    public boolean isResuseMessageId() {
        return this.reuseMessageId;
    }

    public void setReuseMessageId(boolean reuseMessageId) {
        this.reuseMessageId = reuseMessageId;
    }

    protected short getProducerId() {
        return this.producerId;
    }

    public void setProducerId(short producerId) {
        this.producerId = producerId;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    protected long getNextSequenceNumber() {
        return this.idGenerator.getNextSequence();
    }

    protected String getProducerMessageKey() {
        return this.idGenerator.getSeed();
    }
}

