/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.ProtocolException;
import org.activemq.message.Packet;
import org.activemq.message.Receipt;
import org.activemq.transport.stomp.Abort;
import org.activemq.transport.stomp.Ack;
import org.activemq.transport.stomp.Begin;
import org.activemq.transport.stomp.Command;
import org.activemq.transport.stomp.Commit;
import org.activemq.transport.stomp.Disconnect;
import org.activemq.transport.stomp.FrameBuilder;
import org.activemq.transport.stomp.PacketEnvelope;
import org.activemq.transport.stomp.ReceiptListener;
import org.activemq.transport.stomp.Send;
import org.activemq.transport.stomp.StompWireFormat;
import org.activemq.transport.stomp.Subscribe;
import org.activemq.transport.stomp.Unsubscribe;

class CommandParser {
    private String clientId;
    private final StompWireFormat format;

    CommandParser(StompWireFormat wireFormat) {
        this.format = wireFormat;
    }

    Packet parse(DataInput in) throws IOException {
        String line;
        try {
            while ((line = in.readLine()).trim().length() == 0) {
            }
        }
        catch (NullPointerException e) {
            throw new IOException("connection was closed");
        }
        Command command = null;
        if (line.startsWith("SUB")) {
            command = new Subscribe(this.format);
        }
        if (line.startsWith("SEND")) {
            command = new Send(this.format);
        }
        if (line.startsWith("DISCONNECT")) {
            command = new Disconnect(this.clientId);
        }
        if (line.startsWith("BEGIN")) {
            command = new Begin(this.format);
        }
        if (line.startsWith("COMMIT")) {
            command = new Commit(this.format);
        }
        if (line.startsWith("ABORT")) {
            command = new Abort(this.format);
        }
        if (line.startsWith("UNSUB")) {
            command = new Unsubscribe(this.format);
        }
        if (line.startsWith("ACK")) {
            command = new Ack(this.format);
        }
        if (command == null) {
            while (in.readByte() == 0) {
            }
            throw new ProtocolException("Unknown command [" + line + "]");
        }
        PacketEnvelope envelope = command.build(line, in);
        if (envelope.getHeaders().containsKey("receipt")) {
            final short id = StompWireFormat.PACKET_IDS.getNextShortSequence();
            envelope.getPacket().setId(id);
            envelope.getPacket().setReceiptRequired(true);
            final String client_packet_key = envelope.getHeaders().getProperty("receipt");
            this.format.addReceiptListener(new ReceiptListener(){

                public boolean onReceipt(Receipt receipt, DataOutput out) throws IOException {
                    if (receipt.getCorrelationId() != id) {
                        return false;
                    }
                    out.write(new FrameBuilder("RECEIPT").addHeader("receipt-id", client_packet_key).toFrame());
                    return true;
                }
            });
        }
        return envelope.getPacket();
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

