/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.activemq.broker.BrokerContainer;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.StatelessDefaultWireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.MessageIdentity;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCMessageStore;
import org.activemq.store.jdbc.JDBCTopicMessageStore;
import org.activemq.store.jdbc.TransactionContext;
import org.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.activemq.store.vm.VMTransactionStore;
import org.activemq.util.FactoryFinder;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCPersistenceAdapter
implements PersistenceAdapter {
    private static final Log log = LogFactory.getLog((Class)JDBCPersistenceAdapter.class);
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/activemq/store/jdbc/");
    private WireFormat wireFormat = new StatelessDefaultWireFormat();
    private DataSource dataSource;
    private JDBCAdapter adapter;
    private String adapterClass;
    private VMTransactionStore transactionStore;
    private boolean dropTablesOnStartup = false;
    private ClockDaemon clockDaemon;
    private Object clockTicket;
    private DeadLetterPolicy deadLetterPolicy;
    private BrokerContainer brokerContainer;
    private boolean autoCleanupExpiredMessages = true;
    private boolean deleteExpiredMessages = true;
    private long cleanupRepeatInterval = 300000L;
    private int cleanupPeriod = 300000;
    private String tablePrefix = "";

    public JDBCPersistenceAdapter() {
    }

    public JDBCPersistenceAdapter(DataSource ds, WireFormat wireFormat) {
        this.dataSource = ds;
        this.wireFormat = wireFormat;
    }

    public Map getInitialDestinations() {
        return null;
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        MessageStore store = new JDBCMessageStore(this, this.adapter, this.wireFormat.copy(), destinationName);
        if (this.transactionStore != null) {
            store = this.transactionStore.proxy(store);
        }
        return store;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        TopicMessageStore store = new JDBCTopicMessageStore(this, this.adapter, this.wireFormat.copy(), destinationName);
        if (this.transactionStore != null) {
            store = this.transactionStore.proxy(store);
        }
        return store;
    }

    public TransactionStore createTransactionStore() throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        if (this.transactionStore == null) {
            this.transactionStore = new VMTransactionStore();
        }
        return this.transactionStore;
    }

    public void beginTransaction() throws JMSException {
        try {
            Connection c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            TransactionContext.pushConnection(c);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to create transaction: " + e, e);
        }
    }

    public void commitTransaction() throws JMSException {
        Connection c = TransactionContext.popConnection();
        if (c == null) {
            log.warn((Object)"Commit while no transaction in progress");
        } else {
            try {
                c.commit();
            }
            catch (SQLException e) {
                throw JMSExceptionHelper.newJMSException("Failed to commit transaction: " + c + ": " + e, e);
            }
            finally {
                try {
                    c.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        Connection c = TransactionContext.popConnection();
        try {
            c.rollback();
        }
        catch (SQLException e) {
            log.warn((Object)("Cannot rollback transaction due to: " + e), (Throwable)e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.beginTransaction();
        Connection c = null;
        try {
            this.adapter = null;
            try {
                c = this.getConnection();
            }
            catch (SQLException e) {
                throw JMSExceptionHelper.newJMSException("Could not get a database connection: " + e, e);
            }
            if (this.adapterClass == null) {
                try {
                    String driverName = c.getMetaData().getDriverName();
                    driverName = driverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
                    try {
                        this.adapter = (DefaultJDBCAdapter)factoryFinder.newInstance(driverName);
                        log.info((Object)("Database driver recognized: [" + driverName + "]"));
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Database driver NOT recognized: [" + driverName + "].  Will use default JDBC implementation."));
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)("JDBC error occured while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage()));
                    log.debug((Object)("Reason: " + e), (Throwable)e);
                }
            } else {
                try {
                    Class<?> clazz = JDBCPersistenceAdapter.class.getClassLoader().loadClass(this.adapterClass);
                    this.adapter = (DefaultJDBCAdapter)clazz.newInstance();
                }
                catch (Throwable e) {
                    log.warn((Object)("Invalid JDBC adapter class class (" + this.adapterClass + ").  Will use default JDBC implementation."));
                    log.debug((Object)("Reason: " + e), e);
                }
            }
            if (this.adapter == null) {
                this.adapter = new DefaultJDBCAdapter();
            }
            this.adapter.getStatementProvider().setTablePrefix(this.tablePrefix);
            if (this.dropTablesOnStartup) {
                try {
                    this.adapter.doDropTables(c);
                }
                catch (SQLException e) {
                    log.warn((Object)("Cannot drop tables due to: " + e), (Throwable)e);
                }
            }
            try {
                this.adapter.doCreateTables(c);
            }
            catch (SQLException e) {
                log.warn((Object)("Cannot create tables due to: " + e), (Throwable)e);
            }
            this.adapter.initSequenceGenerator(c);
        }
        finally {
            this.commitTransaction();
        }
        if (this.isAutoCleanupExpiredMessages()) {
            this.clockTicket = this.getClockDaemon().executePeriodically(this.getCleanupRepeatInterval(), new Runnable(){

                public void run() {
                    try {
                        JDBCPersistenceAdapter.this.cleanup();
                    }
                    catch (SQLException sqle) {
                        log.error((Object)("Error in cleanup due to: " + sqle), (Throwable)sqle);
                    }
                }
            }, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanup() throws SQLException {
        block9: {
            final Connection c = this.getConnection();
            try {
                try {
                    log.debug((Object)"Cleaning up old messages in the database");
                    this.adapter.doDeleteOldMessages(c);
                    this.adapter.doGetExpiredMessages(c, new JDBCAdapter.ExpiredMessageResultHandler(){

                        public void onMessage(long seq, String container, String messageID, boolean isSentToDeadLetter) {
                            try {
                                MessageStore messageStore = JDBCPersistenceAdapter.this.createQueueMessageStore(container);
                                MessageIdentity messageIdentity = new MessageIdentity(messageID, new Long(seq));
                                ActiveMQMessage message = messageStore.getMessage(messageIdentity);
                                if (message != null) {
                                    log.debug((Object)("Cleaning up old message in the database: " + message.toString()));
                                    if (message.isExpired() && !isSentToDeadLetter) {
                                        JDBCPersistenceAdapter.this.sendToDeadLetter(message);
                                    } else {
                                        log.warn((Object)("could not find message from store with identity: " + messageIdentity + " in cleanup"));
                                    }
                                }
                                JDBCPersistenceAdapter.this.cleanupOldMessage(c, new MessageIdentity(messageID, new Long(seq)));
                            }
                            catch (JMSException jmse) {
                                log.warn((Object)("Cleanup expired message failed due to: " + (Object)((Object)jmse)), (Throwable)jmse);
                            }
                            catch (SQLException sqle) {
                                log.warn((Object)("Cleanup expired message failed due to: " + sqle), (Throwable)sqle);
                            }
                        }
                    });
                }
                catch (JMSException e) {
                    log.warn((Object)("Old message cleanup failed due to: " + (Object)((Object)e)), (Throwable)e);
                    Object var4_3 = null;
                    if (c != null) {
                        this.returnConnection(c);
                    }
                    log.debug((Object)"Cleanup done.");
                    return;
                }
                catch (SQLException e) {
                    log.warn((Object)("Old message cleanup failed due to: " + e), (Throwable)e);
                    Object var4_4 = null;
                    if (c != null) {
                        this.returnConnection(c);
                    }
                    log.debug((Object)"Cleanup done.");
                    return;
                }
                Object var4_2 = null;
                if (c == null) break block9;
                this.returnConnection(c);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (c != null) {
                    this.returnConnection(c);
                }
                log.debug((Object)"Cleanup done.");
                throw throwable;
            }
        }
        log.debug((Object)"Cleanup done.");
    }

    protected void sendToDeadLetter(ActiveMQMessage message) throws JMSException {
        DeadLetterPolicy deadLetterPolicy;
        if (this.getBrokerContainer() != null && (deadLetterPolicy = this.getBrokerContainer().getBroker().getDeadLetterPolicy()) != null && deadLetterPolicy.isDeadLetterEnabled()) {
            deadLetterPolicy.sendToDeadLetter(message);
        }
    }

    public void cleanupOldMessage(Connection c, MessageIdentity messageIdentity) throws JMSException, SQLException {
        if (this.getDeleteExpiredMessages()) {
            this.adapter.doDeleteExpiredMessage(c, messageIdentity);
        }
    }

    public boolean deadLetterAlreadySent(long seq, boolean useDatabaseLocking) {
        final BooleanWrapper alreadySentToDeadLetter = new BooleanWrapper(true);
        try {
            this.beginTransaction();
            Connection c = this.getConnection();
            this.getJDBCAdapter().doGetMessageForUpdate(c, seq, useDatabaseLocking, new JDBCAdapter.ExpiredMessageResultHandler(){

                public void onMessage(long seq, String container, String messageID, boolean isSentToDeadLetter) {
                    if (!isSentToDeadLetter) {
                        alreadySentToDeadLetter.setValue(false);
                    }
                }
            });
            if (!alreadySentToDeadLetter.getValue()) {
                this.getJDBCAdapter().doSetDeadLetterFlag(c, seq);
            }
            this.commitTransaction();
            return alreadySentToDeadLetter.getValue();
        }
        catch (Exception e) {
            log.error((Object)("Could not get a database connection due to: " + e), (Throwable)e);
            this.rollbackTransaction();
            return true;
        }
    }

    public void setClockDaemon(ClockDaemon clockDaemon) {
        this.clockDaemon = clockDaemon;
    }

    public ClockDaemon getClockDaemon() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ClockDaemon();
            this.clockDaemon.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "Cleanup Timmer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public synchronized void stop() throws JMSException {
        if (this.clockTicket != null) {
            ClockDaemon.cancel((Object)this.clockTicket);
            this.clockTicket = null;
            this.clockDaemon.shutDown();
        }
    }

    public BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public void setBrokerContainer(BrokerContainer brokerContainer) {
        this.brokerContainer = brokerContainer;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public Connection getConnection() throws SQLException {
        Connection answer = TransactionContext.peekConnection();
        if (answer == null) {
            answer = this.dataSource.getConnection();
            answer.setAutoCommit(true);
        }
        return answer;
    }

    public void returnConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        Connection peek = TransactionContext.peekConnection();
        if (peek != connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getAdapterClass() {
        return this.adapterClass;
    }

    public void setAdapterClass(String adapterClass) {
        this.adapterClass = adapterClass;
    }

    public JDBCAdapter getJDBCAdapter() {
        return this.adapter;
    }

    public boolean getDropTablesOnStartup() {
        return this.dropTablesOnStartup;
    }

    public void setDropTablesOnStartup(boolean dropTablesOnStartup) {
        this.dropTablesOnStartup = dropTablesOnStartup;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public boolean getDeleteExpiredMessages() {
        return this.deleteExpiredMessages;
    }

    public void setDeleteExpiredMessages(boolean deleteExpiredMessages) {
        this.deleteExpiredMessages = deleteExpiredMessages;
    }

    public boolean isAutoCleanupExpiredMessages() {
        return this.autoCleanupExpiredMessages;
    }

    public void setAutoCleanupExpiredMessages(boolean autoCleanupExpiredMessages) {
        this.autoCleanupExpiredMessages = autoCleanupExpiredMessages;
    }

    public long getCleanupRepeatInterval() {
        return this.cleanupRepeatInterval;
    }

    public void setCleanupRepeatInterval(long cleanupRepeatInterval) {
        this.cleanupRepeatInterval = cleanupRepeatInterval;
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(int cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    private class BooleanWrapper {
        boolean value;

        BooleanWrapper(boolean value) {
            this.setValue(value);
        }

        boolean getValue() {
            return this.value;
        }

        void setValue(boolean value) {
            this.value = value;
        }
    }
}

