/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.activemq.message.ActiveMQXid;
import org.activemq.service.MessageIdentity;
import org.activemq.service.SubscriberEntry;
import org.activemq.store.TransactionStore;
import org.activemq.store.jdbc.StatementProvider;
import org.activemq.util.LongSequenceGenerator;

public interface JDBCAdapter {
    public LongSequenceGenerator getSequenceGenerator();

    public void doCreateTables(Connection var1) throws SQLException;

    public void doDropTables(Connection var1) throws SQLException;

    public void initSequenceGenerator(Connection var1);

    public void doAddMessage(Connection var1, long var2, String var4, String var5, byte[] var6, long var7) throws SQLException, JMSException;

    public byte[] doGetMessage(Connection var1, long var2) throws SQLException;

    public void doGetMessageForUpdate(Connection var1, long var2, boolean var4, ExpiredMessageResultHandler var5) throws SQLException, JMSException;

    public void doRemoveMessage(Connection var1, long var2) throws SQLException;

    public void doRecover(Connection var1, String var2, MessageListResultHandler var3) throws SQLException, JMSException;

    public void doRemoveXid(Connection var1, ActiveMQXid var2) throws SQLException, XAException;

    public void doAddXid(Connection var1, ActiveMQXid var2) throws SQLException, XAException;

    public void doLoadPreparedTransactions(Connection var1, TransactionStore.RecoveryListener var2) throws SQLException;

    public void doSetLastAck(Connection var1, String var2, String var3, long var4) throws SQLException, JMSException;

    public void doRecoverSubscription(Connection var1, String var2, String var3, MessageListResultHandler var4) throws SQLException, JMSException;

    public void doSetSubscriberEntry(Connection var1, String var2, String var3, SubscriberEntry var4) throws SQLException, JMSException;

    public SubscriberEntry doGetSubscriberEntry(Connection var1, String var2, String var3) throws SQLException, JMSException;

    public Long getMessageSequenceId(Connection var1, String var2) throws SQLException, JMSException;

    public void doRemoveAllMessages(Connection var1, String var2) throws SQLException, JMSException;

    public void doDeleteSubscription(Connection var1, String var2, String var3) throws SQLException, JMSException;

    public void doDeleteOldMessages(Connection var1) throws SQLException, JMSException;

    public void doGetExpiredMessages(Connection var1, ExpiredMessageResultHandler var2) throws SQLException, JMSException;

    public void doDeleteExpiredMessage(Connection var1, MessageIdentity var2) throws SQLException, JMSException;

    public void doSetDeadLetterFlag(Connection var1, long var2) throws SQLException, JMSException;

    public StatementProvider getStatementProvider();

    public static interface ExpiredMessageResultHandler {
        public void onMessage(long var1, String var3, String var4, boolean var5) throws JMSException;
    }

    public static interface MessageListResultHandler {
        public void onMessage(long var1, String var3) throws JMSException;
    }
}

