/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.jabber;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activemq.io.WireFormat;
import org.activemq.message.Packet;
import org.activemq.transport.TransportStatusEvent;
import org.activemq.transport.jabber.JabberWireFormat;
import org.activemq.transport.tcp.TcpBufferedOutputStream;
import org.activemq.transport.tcp.TcpTransportChannel;
import org.activemq.transport.tcp.TcpTransportServerChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabberTransportChannel
extends TcpTransportChannel {
    private static final Log log = LogFactory.getLog((Class)JabberTransportChannel.class);
    private XMLInputFactory inputFactory;
    private BufferedInputStream in;

    public JabberTransportChannel() {
        super(new JabberWireFormat());
    }

    public JabberTransportChannel(URI remoteLocation) throws JMSException {
        super(new JabberWireFormat(), remoteLocation);
    }

    public JabberTransportChannel(URI remoteLocation, URI localLocation) throws JMSException {
        super((WireFormat)new JabberWireFormat(), remoteLocation, localLocation);
    }

    public JabberTransportChannel(TcpTransportServerChannel serverChannel, Socket socket, Executor executor) throws JMSException {
        super(serverChannel, new JabberWireFormat(), socket, executor);
    }

    public JabberTransportChannel(Socket socket, Executor executor) throws JMSException {
        super((WireFormat)new JabberWireFormat(), socket, executor);
    }

    public void run() {
        System.out.println("Jabber consumer thread starting");
        log.trace((Object)"Jabber consumer thread starting");
        int count = 0;
        try {
            if (this.inputFactory == null) {
                this.inputFactory = XMLInputFactory.newInstance();
            }
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(this.in, "UTF-8");
            this.getJabberWireFormat().initialize();
            ArrayList list = new ArrayList();
            while (!this.isClosed()) {
                list.clear();
                if (this.isServerSide() && ++count > 500) {
                    count = 0;
                    Thread.yield();
                }
                if (!reader.hasNext()) {
                    this.stop();
                    break;
                }
                this.getJabberWireFormat().readPacket(reader, list);
                for (int i = 0; i < list.size(); ++i) {
                    Packet packet = (Packet)list.get(i);
                    if (packet == null) continue;
                    this.doConsumePacket(packet);
                }
            }
            this.stop();
        }
        catch (XMLStreamException e) {
            this.doClose(e);
        }
        catch (JMSException e) {
            this.doClose((Exception)((Object)e));
        }
        catch (IOException e) {
            this.doClose(e);
        }
    }

    public JabberWireFormat getJabberWireFormat() {
        return (JabberWireFormat)this.getWireFormat();
    }

    protected void initializeStreams() throws IOException {
        System.out.println("Creating input stream");
        this.in = new BufferedInputStream(this.socket.getInputStream(), 8192);
        this.dataIn = new DataInputStream(this.in);
        System.out.println("creating output stream");
        TcpBufferedOutputStream buffOut = new TcpBufferedOutputStream(this.socket.getOutputStream(), 8192);
        this.dataOut = new DataOutputStream(buffOut);
        System.out.println("Creating print writer...");
        PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
        this.getJabberWireFormat().setWriter(writer);
        System.out.println("Firing event");
        this.fireStatusEvent(new TransportStatusEvent(this, 1));
    }
}

