/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import java.util.HashMap;
import java.util.Iterator;
import org.activemq.io.util.MemoryBoundedObject;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.message.ActiveMQMessage;
import org.activemq.service.QueueListEntry;
import org.activemq.service.impl.DefaultQueueList;
import org.activemq.store.cache.MessageCache;

public class MemoryBoundedMessageCache
implements MessageCache,
MemoryBoundedObject {
    private static final int OBJECT_OVERHEAD = 50;
    private final MemoryBoundedObjectManager memoryManager;
    private final HashMap messages = new HashMap();
    private final DefaultQueueList lruList = new DefaultQueueList();
    private int memoryUsedByThisCache;
    private float growthLimit = 0.75f;
    private boolean closed;

    public MemoryBoundedMessageCache(MemoryBoundedObjectManager memoryManager) {
        this.memoryManager = memoryManager;
        this.memoryManager.add(this);
    }

    public synchronized ActiveMQMessage get(String msgid) {
        CacheNode rc = (CacheNode)this.messages.get(msgid);
        if (rc != null) {
            this.lruList.remove(rc.entry);
            rc.entry = this.lruList.addFirst(msgid);
            return rc.message;
        }
        return null;
    }

    public synchronized void put(String messageID, ActiveMQMessage message) {
        while (this.isFull() && !this.messages.isEmpty()) {
            this.removeOldest();
        }
        if (!this.isFull()) {
            this.incrementMemoryUsed(message);
            CacheNode newNode = new CacheNode();
            newNode.message = message;
            newNode.entry = this.lruList.addFirst(messageID);
            CacheNode oldNode = this.messages.put(messageID, newNode);
            if (oldNode != null) {
                this.lruList.remove(oldNode);
                this.decrementMemoryUsed(oldNode.message);
            }
        }
    }

    private void removeOldest() {
        String messageID = (String)this.lruList.removeLast();
        CacheNode node = (CacheNode)this.messages.remove(messageID);
        this.decrementMemoryUsed(node.message);
    }

    private boolean isFull() {
        return this.memoryManager.getPercentFull() > this.growthLimit;
    }

    public synchronized void remove(String messageID) {
        CacheNode node = (CacheNode)this.messages.remove(messageID);
        if (node != null) {
            this.lruList.remove(node.entry);
            this.decrementMemoryUsed(node.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementMemoryUsed(ActiveMQMessage packet) {
        if (packet != null) {
            int size = 50;
            if (packet != null && packet.incrementMemoryReferenceCount() == 1) {
                size += packet.getMemoryUsage();
            }
            MemoryBoundedMessageCache memoryBoundedMessageCache = this;
            synchronized (memoryBoundedMessageCache) {
                this.memoryUsedByThisCache += size;
            }
            this.memoryManager.incrementMemoryUsed(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementMemoryUsed(ActiveMQMessage packet) {
        if (packet != null) {
            int size = 50;
            if (packet != null && packet.decrementMemoryReferenceCount() == 0) {
                size += packet.getMemoryUsage();
            }
            MemoryBoundedMessageCache memoryBoundedMessageCache = this;
            synchronized (memoryBoundedMessageCache) {
                this.memoryUsedByThisCache -= size;
            }
            this.memoryManager.decrementMemoryUsed(size);
        }
    }

    public float getGrowthLimit() {
        return this.growthLimit;
    }

    public void setGrowthLimit(float growTillFence) {
        this.growthLimit = growTillFence;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator iter = this.messages.values().iterator();
        while (iter.hasNext()) {
            CacheNode node = (CacheNode)iter.next();
            this.decrementMemoryUsed(node.message);
        }
        this.messages.clear();
        this.lruList.clear();
        this.memoryManager.remove(this);
    }

    private static class CacheNode {
        ActiveMQMessage message;
        QueueListEntry entry;

        private CacheNode() {
        }
    }
}

