/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.util.Iterator;
import java.util.Properties;
import org.activemq.transport.stomp.Stomp;

class FrameBuilder {
    private String command;
    private Properties headers = new Properties();
    private String body = "";

    FrameBuilder(String command) {
        this.command = command;
    }

    FrameBuilder addHeader(String key, String value) {
        this.headers.setProperty(key, value);
        return this;
    }

    FrameBuilder setBody(String body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.command);
        buffer.append(Stomp.NEWLINE);
        Iterator<Object> iterator = this.headers.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            buffer.append(key).append(":").append(this.headers.getProperty(key)).append(Stomp.NEWLINE);
        }
        buffer.append(Stomp.NEWLINE);
        buffer.append(this.body);
        buffer.append("\u0000");
        buffer.append(Stomp.NEWLINE);
        return buffer.toString();
    }

    String toFrame() {
        return this.toString();
    }
}

