/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.net.ProtocolException;
import javax.jms.Destination;
import org.activemq.message.ActiveMQDestination;

class DestinationNamer {
    DestinationNamer() {
    }

    static ActiveMQDestination convert(String name) throws ProtocolException {
        if (name.startsWith("/queue/")) {
            String q_name = name.substring("/queue/".length(), name.length());
            return ActiveMQDestination.createDestination(3, q_name);
        }
        if (name.startsWith("/topic/")) {
            String t_name = name.substring("/topic/".length(), name.length());
            return ActiveMQDestination.createDestination(1, t_name);
        }
        throw new ProtocolException("Illegal destination name: [" + name + "] -- ActiveMQ TTMP destinations " + "must begine with /queue/ or /topic/");
    }

    static String convert(Destination d) {
        ActiveMQDestination amq_d = (ActiveMQDestination)d;
        String p_name = amq_d.getPhysicalName();
        StringBuffer buffer = new StringBuffer();
        if (amq_d.isQueue()) {
            buffer.append("/queue/");
        }
        if (amq_d.isTopic()) {
            buffer.append("/topic/");
        }
        buffer.append(p_name);
        return buffer.toString();
    }
}

