/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.vm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQQueue;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.vm.VMMessageStore;
import org.activemq.store.vm.VMTopicMessageStore;
import org.activemq.store.vm.VMTransactionStore;

public class VMPersistenceAdapter
implements PersistenceAdapter {
    VMTransactionStore transactionStore = null;
    ConcurrentHashMap destinations = new ConcurrentHashMap();

    public Map getInitialDestinations() {
        HashMap<String, ActiveMQDestination> rc = new HashMap<String, ActiveMQDestination>(this.destinations.size());
        Iterator iter = this.destinations.keySet().iterator();
        while (iter.hasNext()) {
            ActiveMQDestination dest = (ActiveMQDestination)iter.next();
            rc.put(dest.getPhysicalName(), dest);
        }
        return rc;
    }

    public static VMPersistenceAdapter newInstance(File file) {
        return new VMPersistenceAdapter();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        ActiveMQQueue dest = new ActiveMQQueue(destinationName);
        MessageStore rc = (MessageStore)this.destinations.get((Object)dest);
        if (rc == null) {
            rc = new VMMessageStore();
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.destinations.put((Object)dest, (Object)rc);
        }
        return rc;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        ActiveMQQueue dest = new ActiveMQQueue(destinationName);
        TopicMessageStore rc = (TopicMessageStore)this.destinations.get((Object)dest);
        if (rc == null) {
            rc = new VMTopicMessageStore();
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.destinations.put((Object)dest, (Object)rc);
        }
        return rc;
    }

    public TransactionStore createTransactionStore() throws JMSException {
        if (this.transactionStore == null) {
            this.transactionStore = new VMTransactionStore();
        }
        return this.transactionStore;
    }

    public void beginTransaction() {
    }

    public void commitTransaction() {
    }

    public void rollbackTransaction() {
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }
}

