/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.spring;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.activemq.ActiveMQConnectionMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ActiveMQDtdResolver
implements EntityResolver {
    private static final String DTD_NAME = "activemq.dtd";
    private static final String SEARCH_PACKAGE = "/org/activemq/";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        this.logger.debug((Object)("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]"));
        InputSource source = null;
        if (systemId != null && systemId.indexOf(DTD_NAME) > systemId.lastIndexOf("/") && (source = this.resolveRemotely(publicId, systemId)) == null) {
            source = this.resolveLocally(publicId, systemId);
        }
        return source;
    }

    InputSource resolveRemotely(String publicId, String systemId) {
        InputSource source = null;
        if (systemId.endsWith(DTD_NAME)) {
            String dtdFile = "http://activemq.org/dtd/" + ActiveMQConnectionMetaData.PROVIDER_VERSION + "/" + DTD_NAME;
            this.logger.debug((Object)("Trying to locate [" + dtdFile + "]"));
            try {
                URL url = new URL(dtdFile);
                InputStream stream = url.openStream();
                if (stream != null) {
                    source = new InputSource(stream);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    this.logger.debug((Object)("Found beans DTD [" + systemId + "] at: " + dtdFile));
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)("Could not resolve beans DTD [" + systemId + "]: not found in classpath"), (Throwable)ex);
            }
        }
        return null;
    }

    InputSource resolveLocally(String publicId, String systemId) {
        String dtdFile = systemId.substring(systemId.indexOf(DTD_NAME));
        this.logger.debug((Object)("Trying to locate [" + dtdFile + "] under [" + SEARCH_PACKAGE + "]"));
        try {
            String name = SEARCH_PACKAGE + dtdFile;
            ClassPathResource resource = new ClassPathResource(name, this.getClass());
            InputSource source = new InputSource(resource.getInputStream());
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            this.logger.debug((Object)("Found beans DTD [" + systemId + "] in classpath"));
            return source;
        }
        catch (IOException ex) {
            this.logger.debug((Object)("Could not resolve beans DTD [" + systemId + "]: not found in classpath"), (Throwable)ex);
            return null;
        }
    }
}

