/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionSupport {
    private static final Log log = LogFactory.getLog((Class)ReflectionSupport.class);

    public static void setProperties(Object target, Map props) {
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = props.get(name);
            ReflectionSupport.setProperty(target, name, value);
        }
    }

    private static void setProperty(Object target, String name, Object value) {
        Class<?> clazz = target.getClass();
        Method setter = ReflectionSupport.findSetterMethod(clazz, name);
        try {
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, ReflectionSupport.convert(value, setter.getParameterTypes()[0]));
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Could not set property: " + name + ", value: " + value));
        }
    }

    private static Object convert(Object value, Class type) throws URISyntaxException {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }

    private static Method findSetterMethod(Class clazz, String name) {
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1 || !ReflectionSupport.isSettableType(params[0])) continue;
            return method;
        }
        return null;
    }

    private static boolean isSettableType(Class clazz) {
        if (PropertyEditorManager.findEditor(clazz) != null) {
            return true;
        }
        return clazz == URI.class;
    }
}

