/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.ConfigurationException;
import org.activemq.io.WireFormat;
import org.activemq.transport.DiscoveryAgent;
import org.activemq.transport.DiscoveryEvent;
import org.activemq.transport.DiscoveryListener;
import org.activemq.transport.composite.CompositeTransportChannelFactory;
import org.activemq.transport.reliable.ReliableTransportChannel;
import org.activemq.util.Callback;
import org.activemq.util.ExceptionTemplate;
import org.activemq.util.MapHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryTransportChannel
extends ReliableTransportChannel
implements DiscoveryListener {
    private static final Log log = LogFactory.getLog((Class)DiscoveryTransportChannel.class);
    private DiscoveryAgent discoveryAgent;
    private String remoteUserName;
    private String remotePassword;

    public DiscoveryTransportChannel(WireFormat wireFormat, DiscoveryAgent discoveryAgent) {
        super(wireFormat);
        this.discoveryAgent = discoveryAgent;
    }

    public void start() throws JMSException {
        if (this.discoveryAgent == null) {
            throw new ConfigurationException("Must be configured with a discoveryAgent property");
        }
        this.discoveryAgent.addDiscoveryListener(this);
        this.discoveryAgent.start();
        super.start();
    }

    public void stop() {
        ExceptionTemplate template = new ExceptionTemplate();
        template.run(new Callback(){

            public void execute() throws Throwable {
                DiscoveryTransportChannel.this.discoveryAgent.stop();
            }
        });
        template.run(new Callback(){

            public void execute() throws Throwable {
                DiscoveryTransportChannel.super.stop();
            }
        });
        Throwable e = template.getFirstException();
        log.warn((Object)("Failed to stop the transport channel cleanly due to: " + e), e);
    }

    public synchronized void addService(DiscoveryEvent event) {
        Map details = event.getServiceDetails();
        String url = MapHelper.getString(details, "connectURL");
        if (url != null) {
            try {
                List uris = this.parseURIs(new URI(url));
                Iterator uter = uris.iterator();
                while (uter.hasNext()) {
                    URI uri = (URI)uter.next();
                    this.addURI(uri, details);
                }
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
            }
        }
    }

    public synchronized void removeService(DiscoveryEvent event) {
        Map details = event.getServiceDetails();
        String url = MapHelper.getString(details, "connectURL");
        if (url != null) {
            try {
                List uris = this.parseURIs(new URI(url));
                Iterator uter = uris.iterator();
                while (uter.hasNext()) {
                    URI uri = (URI)uter.next();
                    this.removeURI(uri);
                }
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not remove remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
            }
        }
    }

    protected void addURI(URI uri, Map details) {
        List urlList = this.getUris();
        if (!urlList.contains(uri)) {
            log.info((Object)("Adding new broker connection URL: " + uri + " with details: " + details));
            urlList.add(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeURI(URI uri) {
        DiscoveryTransportChannel discoveryTransportChannel = this;
        synchronized (discoveryTransportChannel) {
            List urlList = this.getUris();
            if (urlList.remove(uri)) {
                log.info((Object)("Removing broker connection URL: " + uri));
            }
        }
    }

    protected List parseURIs(URI uri) {
        ArrayList<URI> answer = new ArrayList<URI>();
        try {
            CompositeTransportChannelFactory.parseURIs(answer, uri);
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Failed to parse URI: " + uri), (Throwable)e);
            answer.add(uri);
        }
        return answer;
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }
}

