/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.streams;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import org.activemq.io.util.ByteArray;
import org.activemq.message.ActiveMQMessage;

public class JMSInputStream
extends InputStream {
    private static final int ARRAY_SIZE = 10;
    private boolean closed;
    protected ByteArray[] arrays = new ByteArray[10];
    private int offset;
    private int current = 0;
    protected int clen = 0;
    private int markArray = -1;
    private int markOffset = -1;
    private MessageConsumer consumer;

    public JMSInputStream(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new EOFException("JMSInputStream is closed");
        }
        if (this.current == this.clen) {
            this.fillBuffer(1);
        }
        int c = this.arrays[this.current].get(this.offset) & 0xFF;
        ++this.offset;
        if (this.offset == this.arrays[this.current].getLength()) {
            this.offset = 0;
            this.releaseBuffer(this.current);
            ++this.current;
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new EOFException("JMSInputStream is closed");
        }
        int n = off;
        int total = 0;
        int last = Math.min(off + len, b.length);
        if (this.current == this.clen) {
            this.fillBuffer(len);
        }
        while (this.current < this.clen && n < last) {
            int num_left = this.arrays[this.current].getLength() - this.offset;
            int tocopy = Math.min(num_left, last - n);
            System.arraycopy(this.arrays[this.current].getBuf(), this.offset, b, n, tocopy);
            total += tocopy;
            n += tocopy;
            this.offset += tocopy;
            if (this.offset != this.arrays[this.current].getLength()) continue;
            this.offset = 0;
            this.releaseBuffer(this.current);
            ++this.current;
        }
        return total;
    }

    public long skip(long length) throws IOException {
        if (this.closed) {
            throw new EOFException("JMSInputStream is closed!");
        }
        int requested = Math.min((int)length, Integer.MAX_VALUE);
        int totalskipped = 0;
        while (this.current < this.clen && this.arrays[this.current] != null && requested > 0 && this.current != this.clen) {
            int num_left = this.arrays[this.current].getLength() - this.offset;
            if (num_left < requested) {
                requested -= num_left;
                totalskipped += num_left;
                this.releaseBuffer(this.current);
                ++this.current;
                this.offset = 0;
                continue;
            }
            totalskipped += requested;
            this.offset += requested;
            requested = 0;
        }
        return totalskipped;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new EOFException("JMSInputStream is closed!");
        }
        this.fillBuffer(0);
        if (this.current == this.clen) {
            return 0;
        }
        int num_left = this.arrays[this.current].getLength() - this.offset;
        for (int i = this.current + 1; i < this.clen && this.arrays[i] != null; ++i) {
            num_left += this.arrays[i].getLength();
        }
        return num_left;
    }

    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        if (this.markArray == -1) {
            throw new IOException("PooledArrayInputStream not marked!");
        }
        this.current = this.markArray;
        this.offset = this.markOffset;
        this.markArray = -1;
    }

    public void mark(int readlimit) {
        this.markArray = this.current;
        this.markOffset = this.offset;
    }

    private void releaseBuffer(int index) {
        if (this.markArray < 0 || index < this.markArray) {
            for (int i = 0; i <= index; ++i) {
                this.arrays[index] = null;
            }
        }
    }

    private void fillBuffer(int requiredLength) throws IOException {
        int len = 0;
        try {
            do {
                if (this.closed) continue;
                ActiveMQMessage msg = null;
                msg = len == 0 && requiredLength > 0 ? (ActiveMQMessage)this.consumer.receive(2000L) : (ActiveMQMessage)this.consumer.receiveNoWait();
                if (msg != null) {
                    ByteArray ba = msg.getBodyAsBytes();
                    if (ba == null) continue;
                    len += ba.getLength();
                    this.process(ba);
                    continue;
                }
                if (this.closed) break;
            } while (len < requiredLength && !this.closed);
        }
        catch (JMSException jmsEx) {
            throw new IOException(jmsEx.getMessage());
        }
    }

    private void process(ByteArray ba) {
        if (this.current == this.clen && this.clen + 1 == this.arrays.length) {
            this.offset = 0;
            this.current = 0;
            this.clen = 0;
            if (this.arrays.length > 10 && this.markArray == -1) {
                this.arrays = new ByteArray[10];
            }
        }
        this.arrays[this.clen] = ba;
        ++this.clen;
        if (this.clen == this.arrays.length) {
            ByteArray[] old = this.arrays;
            this.arrays = new ByteArray[old.length + 10];
            System.arraycopy(old, 0, this.arrays, 0, old.length);
        }
    }
}

