/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.DestinationMap;
import org.activemq.filter.Filter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.Dispatcher;
import org.activemq.service.RedeliveryPolicy;
import org.activemq.service.Subscription;
import org.activemq.service.SubscriptionContainer;
import org.activemq.service.impl.SubscriptionImpl;

public class SubscriptionContainerImpl
implements SubscriptionContainer {
    private Map subscriptions;
    private DestinationMap destinationIndex = new DestinationMap();
    private RedeliveryPolicy redeliveryPolicy;
    private DeadLetterPolicy deadLetterPolicy;

    public SubscriptionContainerImpl(RedeliveryPolicy redeliveryPolicy, DeadLetterPolicy deadLetterPolicy) {
        this((Map)new ConcurrentHashMap(), redeliveryPolicy, deadLetterPolicy);
    }

    public SubscriptionContainerImpl(Map subscriptions, RedeliveryPolicy redeliveryPolicy, DeadLetterPolicy deadLetterPolicy) {
        this.subscriptions = subscriptions;
        this.redeliveryPolicy = redeliveryPolicy;
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public String toString() {
        return super.toString() + "[size:" + this.subscriptions.size() + "]";
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public Subscription getSubscription(String consumerId) {
        return (Subscription)this.subscriptions.get(consumerId);
    }

    public Subscription removeSubscription(String consumerId) {
        Subscription subscription = (Subscription)this.subscriptions.remove(consumerId);
        if (subscription != null) {
            this.destinationIndex.remove(subscription.getDestination(), subscription);
        }
        return subscription;
    }

    public Set getSubscriptions(ActiveMQDestination destination) {
        Set answer = this.destinationIndex.get(destination);
        if (answer instanceof Set) {
            return answer;
        }
        HashSet<Set> set = new HashSet<Set>(1);
        set.add(answer);
        return set;
    }

    public Iterator subscriptionIterator() {
        return this.subscriptions.values().iterator();
    }

    public Subscription makeSubscription(Dispatcher dispatcher, BrokerClient client, ConsumerInfo info, Filter filter) {
        Subscription subscription = this.createSubscription(dispatcher, client, info, filter);
        this.subscriptions.put(info.getConsumerId(), subscription);
        this.destinationIndex.put(subscription.getDestination(), subscription);
        return subscription;
    }

    protected Subscription createSubscription(Dispatcher dispatcher, BrokerClient client, ConsumerInfo info, Filter filter) {
        return new SubscriptionImpl(dispatcher, client, info, filter, this.getRedeliveryPolicy(), this.getDeadLetterPolicy());
    }
}

