/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.management;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import org.activemq.management.StatisticImpl;

public class CountStatisticImpl
extends StatisticImpl {
    private final SynchronizedLong counter = new SynchronizedLong(0L);
    private CountStatisticImpl parent;

    public CountStatisticImpl(CountStatisticImpl parent, String name, String description) {
        this(name, description);
        this.parent = parent;
    }

    public CountStatisticImpl(String name, String description) {
        this(name, "count", description);
    }

    public CountStatisticImpl(String name, String unit, String description) {
        super(name, unit, description);
    }

    public void reset() {
        super.reset();
        this.counter.set(0L);
    }

    public long getCount() {
        return this.counter.get();
    }

    public void setCount(long count) {
        this.counter.set(count);
    }

    public void add(long amount) {
        this.counter.add(amount);
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.add(amount);
        }
    }

    public void increment() {
        this.counter.increment();
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.increment();
        }
    }

    public void subtract(long amount) {
        this.counter.subtract(amount);
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.subtract(amount);
        }
    }

    public void decrement() {
        this.counter.decrement();
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.decrement();
        }
    }

    public CountStatisticImpl getParent() {
        return this.parent;
    }

    public void setParent(CountStatisticImpl parent) {
        this.parent = parent;
    }

    protected void appendFieldDescription(StringBuffer buffer) {
        buffer.append(" count: ");
        buffer.append(Long.toString(this.counter.get()));
        super.appendFieldDescription(buffer);
    }
}

