/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.spring;

import javax.jms.JMSException;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.BrokerContext;
import org.activemq.spring.SpringBrokerContainerFactory;
import org.activemq.util.IdGenerator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Object lock;
            String version = "";
            Package p = Package.getPackage("org.activemq");
            if (p != null) {
                version = ": " + p.getImplementationVersion();
            }
            System.out.println("ActiveMQ Message Broker" + version);
            System.out.println();
            SpringBrokerContainerFactory factory = new SpringBrokerContainerFactory();
            String file = null;
            if (args.length <= 0) {
                System.out.println("Loading Mesaage Broker from activemq.xml on the CLASSPATH");
                factory.setResource((Resource)new ClassPathResource("activemq.xml"));
            } else {
                file = args[0];
                if (file.equals("-?") || file.equals("?") || file.equals("--help") || file.equals("-h")) {
                    System.out.println("Usage: Main [xmlConfigFile]");
                    System.out.println("If an XML config file is not specified then activemq.xml is used from the CLASSPAHT");
                    return;
                }
                System.out.println("Loading Message Broker from file: " + file);
                factory.setResource((Resource)new FileSystemResource(file));
            }
            IdGenerator idgen = new IdGenerator();
            BrokerContainer container = factory.createBrokerContainer(idgen.generateId(), BrokerContext.getInstance());
            container.start();
            Object object = lock = new Object();
            synchronized (object) {
                lock.wait();
            }
        }
        catch (JMSException e) {
            System.out.println("Caught: " + (Object)((Object)e));
            e.printStackTrace();
            Exception le = e.getLinkedException();
            System.out.println("Reason: " + le);
            if (le != null) {
                le.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }
}

