/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.boundedvm;

import javax.jms.JMSException;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.BrokerConnector;
import org.activemq.filter.Filter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.BrokerInfo;
import org.activemq.message.ConsumerInfo;

public abstract class TransientSubscription {
    protected Filter filter;
    protected ConsumerInfo consumerInfo;
    protected BrokerClient client;
    protected String brokerName;
    protected String clusterName;

    public TransientSubscription(Filter filter, ConsumerInfo info, BrokerClient client) {
        BrokerInfo bi;
        BrokerConnector connector;
        this.filter = filter;
        this.consumerInfo = info;
        this.client = client;
        if (client != null && (connector = client.getBrokerConnector()) != null && (bi = connector.getBrokerInfo()) != null) {
            this.brokerName = bi.getBrokerName();
            this.clusterName = bi.getClusterName();
        }
    }

    public abstract boolean isTarget(ActiveMQMessage var1) throws JMSException;

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public void setConsumerInfo(ConsumerInfo consumerInfo) {
        this.consumerInfo = consumerInfo;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void close() {
    }

    public ActiveMQDestination getDestination() {
        return this.consumerInfo.getDestination();
    }

    public boolean isLocalSubscription() {
        boolean localSubscription = true;
        if (this.client != null) {
            localSubscription = !this.client.isClusteredConnection();
        }
        return localSubscription;
    }
}

