/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import javax.jms.JMSException;
import org.activemq.broker.Broker;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeadLetterPolicy {
    public static final String DEAD_LETTER_PREFIX = "org.activemq.deadletter.";
    private static final String DEFAULT_DEAD_LETTER_NAME = "DLQ";
    private static final Log log = LogFactory.getLog((Class)DeadLetterPolicy.class);
    private Broker broker;
    private String deadLetterPrefix = "org.activemq.deadletter.";
    private String deadLetterName = "DLQ";
    private boolean deadLetterEnabled = true;
    private boolean deadLetterPerDestinationName = true;
    private boolean storeNonPersistentMessages = true;
    private boolean noTopicConsumerEnabled = true;

    public DeadLetterPolicy(Broker broker) {
        this.broker = broker;
    }

    public DeadLetterPolicy() {
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public boolean isDeadLetterEnabled() {
        return this.deadLetterEnabled;
    }

    public void setDeadLetterEnabled(boolean deadLetterEnabled) {
        this.deadLetterEnabled = deadLetterEnabled;
    }

    public boolean isDeadLetterPerDestinationName() {
        return this.deadLetterPerDestinationName;
    }

    public void setDeadLetterPerDestinationName(boolean deadLetterPerDestinationName) {
        this.deadLetterPerDestinationName = deadLetterPerDestinationName;
    }

    public String getDeadLetterName() {
        return this.deadLetterName;
    }

    public void setDeadLetterName(String deadLetterName) {
        this.deadLetterName = deadLetterName;
    }

    public String getDeadLetterPrefix() {
        return this.deadLetterPrefix;
    }

    public void setDeadLetterPrefix(String deadLetterPrefix) {
        this.deadLetterPrefix = deadLetterPrefix;
    }

    public boolean isStoreNonPersistentMessages() {
        return this.storeNonPersistentMessages;
    }

    public void setStoreNonPersistentMessages(boolean storeNonPersistentMessages) {
        this.storeNonPersistentMessages = storeNonPersistentMessages;
    }

    public boolean isNoTopicConsumerEnabled() {
        return this.noTopicConsumerEnabled;
    }

    public void setNoTopicConsumerEnabled(boolean noTopicConsumerEnabled) {
        this.noTopicConsumerEnabled = noTopicConsumerEnabled;
    }

    public String getDeadLetterNameFromDestination(ActiveMQDestination destination) {
        String deadLetterName = this.deadLetterPrefix;
        deadLetterName = this.deadLetterPerDestinationName ? deadLetterName + destination.getPhysicalName() : deadLetterName + deadLetterName;
        return deadLetterName;
    }

    public void sendToDeadLetter(ActiveMQMessage message) throws JMSException {
        if (this.deadLetterEnabled && message != null && (message.isPersistent() || this.storeNonPersistentMessages)) {
            if (this.broker != null) {
                String dlqName = this.getDeadLetterNameFromDestination(message.getJMSActiveMQDestination());
                message.setDispatchedFromDLQ(true);
                this.broker.sendToDeadLetterQueue(dlqName, message);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Passed message: " + message + " to DLQ: " + dlqName));
                }
            } else {
                log.warn((Object)("Broker is not initialized - cannot add to DLQ: " + message));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("DLQ not storing message: " + message));
        }
    }
}

