/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jndi;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.Broker;
import org.activemq.jndi.ReadOnlyContext;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQInitialContextFactory
implements InitialContextFactory {
    private static final transient Log log = LogFactory.getLog((Class)ActiveMQInitialContextFactory.class);
    protected static final String[] defaultConnectionFactoryNames = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    private String connectionPrefix = "connection.";
    private String queuePrefix = "queue.";
    private String topicPrefix = "topic.";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data = new ConcurrentHashMap();
        Broker broker = null;
        String[] names = this.getConnectionFactoryNames(environment);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ActiveMQConnectionFactory factory = this.createConnectionFactory(name, environment);
            if (broker == null) {
                try {
                    broker = factory.getEmbeddedBroker();
                }
                catch (JMSException e) {
                    log.warn((Object)"Failed to get embedded broker", (Throwable)e);
                }
            }
            data.put(name, factory);
        }
        this.createQueues((Map)data, environment);
        this.createTopics((Map)data, environment);
        if (broker != null) {
            data.put("destinations", broker.getDestinationContext(environment));
        }
        return new ReadOnlyContext(environment, (Map)data);
    }

    private ActiveMQConnectionFactory createConnectionFactory(String name, Hashtable environment) {
        Hashtable temp = new Hashtable(environment);
        String prefix = this.connectionPrefix + name + ".";
        Iterator iter = environment.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            Object value = environment.get(key);
            temp.remove(key);
            key = key.substring(prefix.length());
            temp.put(key, value);
        }
        return this.createConnectionFactory(temp);
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    protected String[] getConnectionFactoryNames(Map environment) {
        String factoryNames = (String)environment.get("connectionFactoryNames");
        if (factoryNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer enumeration = new StringTokenizer(factoryNames, ",");
            while (enumeration.hasMoreTokens()) {
                list.add(enumeration.nextToken().trim());
            }
            int size = list.size();
            if (size > 0) {
                String[] answer = new String[size];
                list.toArray(answer);
                return answer;
            }
        }
        return defaultConnectionFactoryNames;
    }

    protected void createQueues(Map data, Hashtable environment) {
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(this.queuePrefix)) continue;
            String jndiName = key.substring(this.queuePrefix.length());
            data.put(jndiName, this.createQueue(entry.getValue().toString()));
        }
    }

    protected void createTopics(Map data, Hashtable environment) {
        Iterator iter = environment.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(this.topicPrefix)) continue;
            String jndiName = key.substring(this.topicPrefix.length());
            data.put(jndiName, this.createTopic(entry.getValue().toString()));
        }
    }

    protected Queue createQueue(String name) {
        return new ActiveMQQueue(name);
    }

    protected Topic createTopic(String name) {
        return new ActiveMQTopic(name);
    }

    protected ActiveMQConnectionFactory createConnectionFactory(Hashtable environment) {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)environment);
        answer.setProperties(properties);
        return answer;
    }

    public String getConnectionPrefix() {
        return this.connectionPrefix;
    }

    public void setConnectionPrefix(String connectionPrefix) {
        this.connectionPrefix = connectionPrefix;
    }
}

