/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.lang.reflect.Method;
import javax.jms.JMSException;
import org.activemq.broker.BrokerContainerFactory;
import org.activemq.util.JMSExceptionHelper;

public class XmlConfigHelper {
    private static final Class[] ARGUMENT_TYPES = new Class[]{String.class};
    public static final String SPRING_CLASS_NAME = "org.activemq.spring.SpringBrokerContainerFactory";

    public static BrokerContainerFactory createBrokerContainerFactory(String xmlConfig) throws JMSException {
        try {
            Class factoryClass = XmlConfigHelper.getSpringFactoryClass();
            Method method = factoryClass.getMethod("newFactory", ARGUMENT_TYPES);
            if (method == null) {
                throw new JMSException("Could not find newFactory() method - classpath strangeness occurred");
            }
            return (BrokerContainerFactory)method.invoke(null, xmlConfig);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionHelper.newJMSException("Could not configure broker using XML configuration file as Spring factory class could not be loaded. Maybe you need the Spring.jar on your classpath? Reason: " + e, e);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.newJMSException("Could not configure broker using XML configuration file as attempt to use Spring factory failed. Reason: " + e, e);
        }
    }

    private static Class getSpringFactoryClass() throws ClassNotFoundException {
        Class<?> answer = null;
        try {
            answer = Thread.currentThread().getContextClassLoader().loadClass(SPRING_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            answer = XmlConfigHelper.class.getClassLoader().loadClass(SPRING_CLASS_NAME);
        }
        return answer;
    }
}

