/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.activemq.service.QueueList;
import org.activemq.service.QueueListEntry;
import org.activemq.service.impl.DefaultQueueListEntry;

public final class DefaultQueueList
implements QueueList,
Cloneable,
Serializable {
    private transient DefaultQueueListEntry header = new DefaultQueueListEntry(null, null, null);
    private transient int size = 0;

    public DefaultQueueList() {
        this.header.next = this.header.previous = this.header;
    }

    public synchronized Object getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.header.next.element;
    }

    public synchronized Object getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.header.previous.element;
    }

    public synchronized Object removeFirst() {
        if (this.size == 0) {
            return null;
        }
        Object first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    public synchronized void rotate() {
        Object obj;
        if (this.size > 1 && (obj = this.removeFirst()) != null) {
            this.addLast(obj);
        }
    }

    public synchronized Object removeLast() {
        if (this.size == 0) {
            return null;
        }
        Object last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    public synchronized QueueListEntry addAllFirst(Collection c) {
        return this.addAllBefore(c, this.header.next);
    }

    public synchronized QueueListEntry addFirst(Object o) {
        return this.addBefore(o, this.header.next);
    }

    public synchronized QueueListEntry addLast(Object o) {
        return this.addBefore(o, this.header);
    }

    public synchronized boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized QueueListEntry add(Object o) {
        return this.addBefore(o, this.header);
    }

    public synchronized boolean remove(Object o) {
        if (o == null) {
            DefaultQueueListEntry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        } else {
            DefaultQueueListEntry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized void clear() {
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public synchronized Object get(int index) {
        return this.entry((int)index).element;
    }

    public synchronized Object get(Object obj) {
        int index = this.indexOf(obj);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    public synchronized Object set(int index, Object element) {
        DefaultQueueListEntry e = this.entry(index);
        Object oldVal = e.element;
        e.element = element;
        return oldVal;
    }

    public synchronized void add(int index, Object element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index));
    }

    public synchronized Object remove(int index) {
        DefaultQueueListEntry e = this.entry(index);
        this.remove(e);
        return e.element;
    }

    public synchronized DefaultQueueListEntry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        DefaultQueueListEntry e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    public synchronized int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            DefaultQueueListEntry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            DefaultQueueListEntry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    public synchronized int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            DefaultQueueListEntry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (e.element == null) {
                    return index;
                }
                e = e.previous;
            }
        } else {
            DefaultQueueListEntry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (o.equals(e.element)) {
                    return index;
                }
                e = e.previous;
            }
        }
        return -1;
    }

    public synchronized QueueListEntry getFirstEntry() {
        DefaultQueueListEntry result = this.header.next;
        return result != this.header ? result : null;
    }

    public synchronized QueueListEntry getLastEntry() {
        DefaultQueueListEntry result = this.header.previous;
        return result != this.header ? result : null;
    }

    public QueueListEntry getNextEntry(QueueListEntry node) {
        DefaultQueueListEntry entry = (DefaultQueueListEntry)node;
        if (entry == null) {
            return null;
        }
        DefaultQueueListEntry result = entry.next;
        return result != entry && result != this.header ? result : null;
    }

    public QueueListEntry getPrevEntry(QueueListEntry node) {
        DefaultQueueListEntry entry = (DefaultQueueListEntry)node;
        if (entry == null) {
            return null;
        }
        DefaultQueueListEntry result = entry.previous;
        return result != entry && result != this.header ? result : null;
    }

    public synchronized QueueListEntry addBefore(Object o, QueueListEntry node) {
        DefaultQueueListEntry newLinkedListEntry;
        DefaultQueueListEntry e = (DefaultQueueListEntry)node;
        newLinkedListEntry.previous.next = newLinkedListEntry = new DefaultQueueListEntry(o, e, e.previous);
        newLinkedListEntry.next.previous = newLinkedListEntry;
        ++this.size;
        return newLinkedListEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized QueueListEntry addAllBefore(Collection c, QueueListEntry node) {
        int i;
        if (c.size() < 1) {
            return node;
        }
        DefaultQueueListEntry e = (DefaultQueueListEntry)node;
        DefaultQueueListEntry[] newLinkedListEntry = new DefaultQueueListEntry[c.size()];
        Iterator iterator = c.iterator();
        for (i = 0; i < newLinkedListEntry.length; ++i) {
            newLinkedListEntry[i] = new DefaultQueueListEntry(iterator.next(), e, i == 0 ? e.previous : newLinkedListEntry[i - 1]);
        }
        for (i = 0; i < newLinkedListEntry.length - 1; ++i) {
            newLinkedListEntry[i].next = newLinkedListEntry[i + 1];
        }
        DefaultQueueList defaultQueueList = this;
        synchronized (defaultQueueList) {
            newLinkedListEntry[0].previous.next = newLinkedListEntry[0];
            newLinkedListEntry[newLinkedListEntry.length - 1].next.previous = newLinkedListEntry[newLinkedListEntry.length - 1];
            this.size += newLinkedListEntry.length;
        }
        return newLinkedListEntry[0];
    }

    public synchronized void remove(QueueListEntry node) {
        DefaultQueueListEntry e = (DefaultQueueListEntry)node;
        if (e == this.header) {
            return;
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
    }

    public synchronized Object clone() {
        DefaultQueueList clone = new DefaultQueueList();
        clone.header.next = clone.header.previous = (clone.header = new DefaultQueueListEntry(null, null, null));
        clone.size = 0;
        DefaultQueueListEntry e = this.header.next;
        while (e != this.header) {
            clone.add(e.element);
            e = e.next;
        }
        return clone;
    }

    public synchronized Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        DefaultQueueListEntry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    public synchronized String toString() {
        String result = super.toString();
        result = result + ":";
        DefaultQueueListEntry e = this.header.next;
        while (e != this.header) {
            result = result + e.element;
            if (e != this.header) {
                result = result + ",";
            }
            e = e.next;
        }
        return result;
    }
}

