/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import org.activemq.io.AbstractWireFormat;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.ActiveMQBytesMessageReader;
import org.activemq.io.impl.ActiveMQBytesMessageWriter;
import org.activemq.io.impl.ActiveMQMapMessageReader;
import org.activemq.io.impl.ActiveMQMapMessageWriter;
import org.activemq.io.impl.ActiveMQMessageReader;
import org.activemq.io.impl.ActiveMQMessageWriter;
import org.activemq.io.impl.ActiveMQObjectMessageReader;
import org.activemq.io.impl.ActiveMQObjectMessageWriter;
import org.activemq.io.impl.ActiveMQStreamMessageReader;
import org.activemq.io.impl.ActiveMQStreamMessageWriter;
import org.activemq.io.impl.ActiveMQTextMessageReader;
import org.activemq.io.impl.ActiveMQTextMessageWriter;
import org.activemq.io.impl.BrokerAdminCommandReader;
import org.activemq.io.impl.BrokerAdminCommandWriter;
import org.activemq.io.impl.BrokerInfoReader;
import org.activemq.io.impl.BrokerInfoWriter;
import org.activemq.io.impl.CachedValueReader;
import org.activemq.io.impl.CachedValueWriter;
import org.activemq.io.impl.CapacityInfoReader;
import org.activemq.io.impl.CapacityInfoRequestReader;
import org.activemq.io.impl.CapacityInfoRequestWriter;
import org.activemq.io.impl.CapacityInfoWriter;
import org.activemq.io.impl.CleanupConnectionInfoReader;
import org.activemq.io.impl.CleanupConnectionInfoWriter;
import org.activemq.io.impl.ConnectionInfoReader;
import org.activemq.io.impl.ConnectionInfoWriter;
import org.activemq.io.impl.ConsumerInfoReader;
import org.activemq.io.impl.ConsumerInfoWriter;
import org.activemq.io.impl.DurableUnsubscribeReader;
import org.activemq.io.impl.DurableUnsubscribeWriter;
import org.activemq.io.impl.IntResponseReceiptReader;
import org.activemq.io.impl.IntResponseReceiptWriter;
import org.activemq.io.impl.KeepAliveReader;
import org.activemq.io.impl.KeepAliveWriter;
import org.activemq.io.impl.MessageAckReader;
import org.activemq.io.impl.MessageAckWriter;
import org.activemq.io.impl.PacketReader;
import org.activemq.io.impl.PacketWriter;
import org.activemq.io.impl.ProducerInfoReader;
import org.activemq.io.impl.ProducerInfoWriter;
import org.activemq.io.impl.ReceiptReader;
import org.activemq.io.impl.ReceiptWriter;
import org.activemq.io.impl.ResponseReceiptReader;
import org.activemq.io.impl.ResponseReceiptWriter;
import org.activemq.io.impl.SessionInfoReader;
import org.activemq.io.impl.SessionInfoWriter;
import org.activemq.io.impl.TransactionInfoReader;
import org.activemq.io.impl.TransactionInfoWriter;
import org.activemq.io.impl.WireFormatInfoReader;
import org.activemq.io.impl.WireFormatInfoWriter;
import org.activemq.io.impl.XATransactionInfoReader;
import org.activemq.io.impl.XATransactionInfoWriter;
import org.activemq.message.AbstractPacket;
import org.activemq.message.CachedValue;
import org.activemq.message.Packet;
import org.activemq.message.WireFormatInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDefaultWireFormat
extends AbstractWireFormat
implements Serializable {
    public static final int WIRE_FORMAT_VERSION = 3;
    private static final Log log = LogFactory.getLog((Class)AbstractDefaultWireFormat.class);
    protected transient PacketReader messageReader;
    protected transient PacketReader textMessageReader;
    protected transient PacketReader objectMessageReader;
    protected transient PacketReader bytesMessageReader;
    protected transient PacketReader streamMessageReader;
    protected transient PacketReader mapMessageReader;
    protected transient PacketReader messageAckReader;
    protected transient PacketReader receiptReader;
    protected transient PacketReader consumerInfoReader;
    protected transient PacketReader producerInfoReader;
    protected transient PacketReader transactionInfoReader;
    protected transient PacketReader xaTransactionInfoReader;
    protected transient PacketReader brokerInfoReader;
    protected transient PacketReader connectionInfoReader;
    protected transient PacketReader sessionInfoReader;
    protected transient PacketReader durableUnsubscribeReader;
    protected transient PacketReader reponseReceiptReader;
    protected transient PacketReader intReponseReceiptReader;
    protected transient PacketReader capacityInfoReader;
    protected transient PacketReader capacityInfoRequestReader;
    protected transient PacketReader wireFormatInfoReader;
    protected transient PacketReader keepAliveReader;
    protected transient PacketReader brokerAdminCommandReader;
    protected transient PacketReader cachedValueReader;
    protected transient PacketReader cleanupConnectionAndSessionInfoReader;
    protected transient PacketWriter messageWriter;
    protected transient PacketWriter textMessageWriter;
    protected transient PacketWriter objectMessageWriter;
    protected transient PacketWriter bytesMessageWriter;
    protected transient PacketWriter streamMessageWriter;
    protected transient PacketWriter mapMessageWriter;
    protected transient PacketWriter messageAckWriter;
    protected transient PacketWriter receiptWriter;
    protected transient PacketWriter consumerInfoWriter;
    protected transient PacketWriter producerInfoWriter;
    protected transient PacketWriter transactionInfoWriter;
    protected transient PacketWriter xaTransactionInfoWriter;
    protected transient PacketWriter brokerInfoWriter;
    protected transient PacketWriter connectionInfoWriter;
    protected transient PacketWriter sessionInfoWriter;
    protected transient PacketWriter durableUnsubscribeWriter;
    protected transient PacketWriter reponseReceiptWriter;
    protected transient PacketWriter intReponseReceiptWriter;
    protected transient PacketWriter capacityInfoWriter;
    protected transient PacketWriter capacityInfoRequestWriter;
    protected transient PacketWriter wireFormatInfoWriter;
    protected transient PacketWriter keepAliveWriter;
    protected transient PacketWriter brokerAdminCommandWriter;
    protected transient PacketWriter cachedValueWriter;
    protected transient PacketWriter cleanupConnectionAndSessionInfoWriter;
    private List readers = new ArrayList();
    private List writers = new ArrayList();
    protected transient int currentWireFormatVersion = 3;

    public AbstractDefaultWireFormat() {
        this.initializeReaders();
        this.initializeWriters();
    }

    public abstract byte[] toBytes(Packet var1) throws IOException;

    public abstract Packet writePacket(Packet var1, DataOutput var2) throws IOException;

    protected abstract Packet readPacket(DataInput var1, PacketReader var2) throws IOException;

    protected abstract void handleCachedValue(CachedValue var1);

    public abstract Object getValueFromReadCache(short var1);

    abstract short getWriteCachedKey(Object var1) throws IOException;

    public void initiateClientSideProtocol(DataOutputStream dataOut, DataInputStream dataIn) throws JMSException {
        WireFormatInfo info = new WireFormatInfo();
        info.setVersion(this.getCurrentWireFormatVersion());
        try {
            this.writePacket(info, dataOut);
            dataOut.flush();
        }
        catch (IOException e) {
            throw new JMSException("Failed to intiate protocol");
        }
    }

    public void initiateServerSideProtocol(DataOutputStream dataOut, DataInputStream dataIn) throws JMSException {
    }

    public abstract WireFormat copy();

    public Packet readPacket(DataInput dataIn) throws IOException {
        byte by;
        int type = -1;
        do {
            by = dataIn.readByte();
            type = by;
        } while (by == 0);
        if (type == -1) {
            throw new IOException("InputStream now closed");
        }
        return this.readPacket(type, dataIn);
    }

    public Packet readPacket(int firstByte, DataInput dataIn) throws IOException {
        switch (firstByte) {
            case 6: {
                return this.readPacket(dataIn, this.messageReader);
            }
            case 7: {
                return this.readPacket(dataIn, this.textMessageReader);
            }
            case 8: {
                return this.readPacket(dataIn, this.objectMessageReader);
            }
            case 9: {
                return this.readPacket(dataIn, this.bytesMessageReader);
            }
            case 10: {
                return this.readPacket(dataIn, this.streamMessageReader);
            }
            case 11: {
                return this.readPacket(dataIn, this.mapMessageReader);
            }
            case 15: {
                return this.readPacket(dataIn, this.messageAckReader);
            }
            case 16: {
                return this.readPacket(dataIn, this.receiptReader);
            }
            case 17: {
                return this.readPacket(dataIn, this.consumerInfoReader);
            }
            case 18: {
                return this.readPacket(dataIn, this.producerInfoReader);
            }
            case 19: {
                return this.readPacket(dataIn, this.transactionInfoReader);
            }
            case 20: {
                return this.readPacket(dataIn, this.xaTransactionInfoReader);
            }
            case 21: {
                return this.readPacket(dataIn, this.brokerInfoReader);
            }
            case 22: {
                return this.readPacket(dataIn, this.connectionInfoReader);
            }
            case 23: {
                return this.readPacket(dataIn, this.sessionInfoReader);
            }
            case 24: {
                return this.readPacket(dataIn, this.durableUnsubscribeReader);
            }
            case 25: {
                return this.readPacket(dataIn, this.reponseReceiptReader);
            }
            case 26: {
                return this.readPacket(dataIn, this.intReponseReceiptReader);
            }
            case 27: {
                return this.readPacket(dataIn, this.capacityInfoReader);
            }
            case 28: {
                return this.readPacket(dataIn, this.capacityInfoRequestReader);
            }
            case 29: {
                WireFormatInfo info = (WireFormatInfo)this.readPacket(dataIn, this.wireFormatInfoReader);
                if (info != null && info.getVersion() < 3) {
                    throw new IOException("Cannot support wire format version: " + info.getVersion());
                }
                return info;
            }
            case 30: {
                return this.readPacket(dataIn, this.keepAliveReader);
            }
            case 31: {
                return this.readPacket(dataIn, this.brokerAdminCommandReader);
            }
            case 32: {
                CachedValue cv = (CachedValue)this.readPacket(dataIn, this.cachedValueReader);
                this.handleCachedValue(cv);
                return null;
            }
            case 33: {
                return this.readPacket(dataIn, this.cleanupConnectionAndSessionInfoReader);
            }
        }
        log.error((Object)("Could not find PacketReader for packet type: " + AbstractPacket.getPacketTypeAsString(firstByte)));
        return null;
    }

    protected PacketWriter getWriter(Packet packet) throws IOException {
        PacketWriter answer = null;
        switch (packet.getPacketType()) {
            case 6: {
                answer = this.messageWriter;
                break;
            }
            case 7: {
                answer = this.textMessageWriter;
                break;
            }
            case 8: {
                answer = this.objectMessageWriter;
                break;
            }
            case 9: {
                answer = this.bytesMessageWriter;
                break;
            }
            case 10: {
                answer = this.streamMessageWriter;
                break;
            }
            case 11: {
                answer = this.mapMessageWriter;
                break;
            }
            case 15: {
                answer = this.messageAckWriter;
                break;
            }
            case 16: {
                answer = this.receiptWriter;
                break;
            }
            case 17: {
                answer = this.consumerInfoWriter;
                break;
            }
            case 18: {
                answer = this.producerInfoWriter;
                break;
            }
            case 19: {
                answer = this.transactionInfoWriter;
                break;
            }
            case 20: {
                answer = this.xaTransactionInfoWriter;
                break;
            }
            case 21: {
                answer = this.brokerInfoWriter;
                break;
            }
            case 22: {
                answer = this.connectionInfoWriter;
                break;
            }
            case 23: {
                answer = this.sessionInfoWriter;
                break;
            }
            case 24: {
                answer = this.durableUnsubscribeWriter;
                break;
            }
            case 25: {
                answer = this.reponseReceiptWriter;
                break;
            }
            case 26: {
                answer = this.intReponseReceiptWriter;
                break;
            }
            case 27: {
                answer = this.capacityInfoWriter;
                break;
            }
            case 28: {
                answer = this.capacityInfoRequestWriter;
                break;
            }
            case 29: {
                answer = this.wireFormatInfoWriter;
                break;
            }
            case 30: {
                answer = this.keepAliveWriter;
                break;
            }
            case 31: {
                answer = this.brokerAdminCommandWriter;
                break;
            }
            case 32: {
                answer = this.cachedValueWriter;
                break;
            }
            case 33: {
                answer = this.cleanupConnectionAndSessionInfoWriter;
                break;
            }
            default: {
                log.error((Object)("no PacketWriter for packet: " + packet));
            }
        }
        return answer;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return version <= 3;
    }

    public int getCurrentWireFormatVersion() {
        return this.currentWireFormatVersion;
    }

    public void setCurrentWireFormatVersion(int version) {
        int i;
        this.currentWireFormatVersion = version;
        for (i = 0; i < this.readers.size(); ++i) {
            PacketReader reader = (PacketReader)this.readers.get(i);
            reader.setWireFormatVersion(version);
        }
        for (i = 0; i < this.writers.size(); ++i) {
            PacketWriter writer = (PacketWriter)this.writers.get(i);
            writer.setWireFormatVersion(version);
        }
    }

    private void initializeReaders() {
        this.messageReader = new ActiveMQMessageReader(this);
        this.readers.add(this.messageReader);
        this.textMessageReader = new ActiveMQTextMessageReader(this);
        this.readers.add(this.textMessageReader);
        this.objectMessageReader = new ActiveMQObjectMessageReader(this);
        this.readers.add(this.objectMessageReader);
        this.bytesMessageReader = new ActiveMQBytesMessageReader(this);
        this.readers.add(this.bytesMessageReader);
        this.streamMessageReader = new ActiveMQStreamMessageReader(this);
        this.readers.add(this.streamMessageReader);
        this.mapMessageReader = new ActiveMQMapMessageReader(this);
        this.readers.add(this.mapMessageReader);
        this.messageAckReader = new MessageAckReader(this);
        this.readers.add(this.messageAckReader);
        this.receiptReader = new ReceiptReader();
        this.readers.add(this.receiptReader);
        this.consumerInfoReader = new ConsumerInfoReader();
        this.readers.add(this.consumerInfoReader);
        this.producerInfoReader = new ProducerInfoReader();
        this.readers.add(this.producerInfoReader);
        this.transactionInfoReader = new TransactionInfoReader();
        this.readers.add(this.transactionInfoReader);
        this.xaTransactionInfoReader = new XATransactionInfoReader();
        this.readers.add(this.xaTransactionInfoReader);
        this.brokerInfoReader = new BrokerInfoReader();
        this.readers.add(this.brokerInfoReader);
        this.connectionInfoReader = new ConnectionInfoReader();
        this.readers.add(this.connectionInfoReader);
        this.sessionInfoReader = new SessionInfoReader();
        this.readers.add(this.sessionInfoReader);
        this.durableUnsubscribeReader = new DurableUnsubscribeReader();
        this.readers.add(this.durableUnsubscribeReader);
        this.reponseReceiptReader = new ResponseReceiptReader();
        this.readers.add(this.reponseReceiptReader);
        this.intReponseReceiptReader = new IntResponseReceiptReader();
        this.readers.add(this.intReponseReceiptReader);
        this.capacityInfoReader = new CapacityInfoReader();
        this.readers.add(this.capacityInfoReader);
        this.capacityInfoRequestReader = new CapacityInfoRequestReader();
        this.readers.add(this.capacityInfoReader);
        this.wireFormatInfoReader = new WireFormatInfoReader(this);
        this.readers.add(this.wireFormatInfoReader);
        this.keepAliveReader = new KeepAliveReader();
        this.readers.add(this.keepAliveReader);
        this.brokerAdminCommandReader = new BrokerAdminCommandReader();
        this.readers.add(this.brokerAdminCommandReader);
        this.cachedValueReader = new CachedValueReader();
        this.readers.add(this.cachedValueReader);
        this.cleanupConnectionAndSessionInfoReader = new CleanupConnectionInfoReader();
        this.readers.add(this.cleanupConnectionAndSessionInfoReader);
    }

    private void initializeWriters() {
        this.messageWriter = new ActiveMQMessageWriter(this);
        this.writers.add(this.messageWriter);
        this.textMessageWriter = new ActiveMQTextMessageWriter(this);
        this.writers.add(this.textMessageWriter);
        this.objectMessageWriter = new ActiveMQObjectMessageWriter(this);
        this.writers.add(this.objectMessageWriter);
        this.bytesMessageWriter = new ActiveMQBytesMessageWriter(this);
        this.writers.add(this.bytesMessageWriter);
        this.streamMessageWriter = new ActiveMQStreamMessageWriter(this);
        this.writers.add(this.streamMessageWriter);
        this.mapMessageWriter = new ActiveMQMapMessageWriter(this);
        this.writers.add(this.mapMessageWriter);
        this.messageAckWriter = new MessageAckWriter(this);
        this.writers.add(this.messageAckWriter);
        this.receiptWriter = new ReceiptWriter();
        this.writers.add(this.receiptWriter);
        this.consumerInfoWriter = new ConsumerInfoWriter();
        this.writers.add(this.consumerInfoWriter);
        this.producerInfoWriter = new ProducerInfoWriter();
        this.writers.add(this.producerInfoWriter);
        this.transactionInfoWriter = new TransactionInfoWriter();
        this.writers.add(this.transactionInfoWriter);
        this.xaTransactionInfoWriter = new XATransactionInfoWriter();
        this.writers.add(this.xaTransactionInfoWriter);
        this.brokerInfoWriter = new BrokerInfoWriter();
        this.writers.add(this.brokerInfoWriter);
        this.connectionInfoWriter = new ConnectionInfoWriter();
        this.writers.add(this.connectionInfoWriter);
        this.sessionInfoWriter = new SessionInfoWriter();
        this.writers.add(this.sessionInfoWriter);
        this.durableUnsubscribeWriter = new DurableUnsubscribeWriter();
        this.writers.add(this.durableUnsubscribeWriter);
        this.reponseReceiptWriter = new ResponseReceiptWriter();
        this.writers.add(this.reponseReceiptWriter);
        this.intReponseReceiptWriter = new IntResponseReceiptWriter();
        this.writers.add(this.intReponseReceiptWriter);
        this.capacityInfoWriter = new CapacityInfoWriter();
        this.writers.add(this.capacityInfoWriter);
        this.capacityInfoRequestWriter = new CapacityInfoRequestWriter();
        this.writers.add(this.capacityInfoWriter);
        this.wireFormatInfoWriter = new WireFormatInfoWriter();
        this.writers.add(this.wireFormatInfoWriter);
        this.keepAliveWriter = new KeepAliveWriter();
        this.writers.add(this.keepAliveWriter);
        this.brokerAdminCommandWriter = new BrokerAdminCommandWriter();
        this.writers.add(this.brokerAdminCommandWriter);
        this.cachedValueWriter = new CachedValueWriter();
        this.writers.add(this.cachedValueWriter);
        this.cleanupConnectionAndSessionInfoWriter = new CleanupConnectionInfoWriter();
        this.writers.add(this.cleanupConnectionAndSessionInfoWriter);
    }
}

