/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.activemq.ActiveMQQueueSession;
import org.activemq.ActiveMQSession;
import org.activemq.ActiveMQTopicSession;
import org.activemq.ActiveMQXAConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQXASession
extends ActiveMQSession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    private static final Log log = LogFactory.getLog((Class)ActiveMQXASession.class);

    public ActiveMQXASession(ActiveMQXAConnection theConnection, int theAcknowlegeMode) throws JMSException {
        super(theConnection, theAcknowlegeMode);
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Cannot rollback() inside an XASession");
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("Cannot commit() inside an XASession");
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        return this.getTransactionContext();
    }

    public QueueSession getQueueSession() throws JMSException {
        return new ActiveMQQueueSession(this);
    }

    public TopicSession getTopicSession() throws JMSException {
        return new ActiveMQTopicSession(this);
    }

    protected void doStartTransaction() throws JMSException {
        if (!this.getTransactionContext().isInXATransaction()) {
            throw new JMSException("Session's XAResource has not been enlisted in a distributed transaction.");
        }
    }
}

